/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log;

import com.android.sched.util.log.LoggerConfiguration;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class LoggerFactory {
    @Nonnull
    public static Logger getLogger() {
        StackTraceElement caller = LoggerFactory.findCaller();
        return Logger.getLogger(caller.getClassName());
    }

    @Nonnull
    private static StackTraceElement findCaller() {
        int idx;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (idx = 0; idx < stack.length && !stack[idx].getClassName().equals(LoggerFactory.class.getName()); ++idx) {
        }
        while (idx < stack.length) {
            if (!stack[idx].getClassName().equals(LoggerFactory.class.getName())) {
                return stack[idx];
            }
            ++idx;
        }
        throw new AssertionError();
    }

    public static void configure(LoggerConfiguration configuration) {
        LogManager manager = LogManager.getLogManager();
        manager.reset();
        List<LoggerConfiguration.PackageLevel> levels = configuration.getLevels();
        if (levels.isEmpty()) {
            return;
        }
        for (LoggerConfiguration.PackageLevel level : levels) {
            Logger.getLogger(level.getPackageName());
        }
        List<LoggerConfiguration.PackageLevel> levelsReverse = Lists.reverse(levels);
        Enumeration<String> names = manager.getLoggerNames();
        Collection<Handler> handlers = configuration.getHandlers();
        block1: while (names.hasMoreElements()) {
            String loggerName = names.nextElement();
            Logger logger = manager.getLogger(loggerName);
            if (logger == null) continue;
            for (Handler handler : handlers) {
                logger.addHandler(handler);
            }
            for (LoggerConfiguration.PackageLevel level : levelsReverse) {
                if (!loggerName.startsWith(level.getPackageName())) continue;
                logger.setLevel(level.getLevel());
                logger.setUseParentHandlers(false);
                continue block1;
            }
        }
    }

    private LoggerFactory() {
    }
}

