/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log;

import java.util.Collection;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public interface LoggerConfiguration {
    @Nonnull
    public Collection<Handler> getHandlers();

    @Nonnull
    public List<PackageLevel> getLevels();

    public static class PackageLevel {
        @Nonnull
        private final String packageName;
        @Nonnull
        private final Level level;

        public PackageLevel(@Nonnull String packageName, @Nonnull Level level) {
            this.packageName = packageName;
            this.level = level;
        }

        @Nonnull
        public String getPackageName() {
            return this.packageName;
        }

        @Nonnull
        public Level getLevel() {
            return this.level;
        }

        public final boolean equals(@CheckForNull Object obj) {
            if (obj instanceof PackageLevel) {
                return this.packageName.equals(((PackageLevel)obj).packageName) && this.level.equals(((PackageLevel)obj).level);
            }
            return super.equals(obj);
        }

        public final int hashCode() {
            return this.packageName.hashCode() ^ this.level.hashCode();
        }
    }
}

