/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.NotJarFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.FileLocation;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class InputJarFile
extends AbstractStreamFile {
    @Nonnull
    private final JarFile jarFile;

    public InputJarFile(@Nonnull String name) throws WrongPermissionException, NotFileException, NoSuchFileException, NotJarFileException {
        this(new File(name), new FileLocation(name));
    }

    public InputJarFile(@CheckForNull Directory workingDirectory, @Nonnull String string) throws NotFileException, WrongPermissionException, NoSuchFileException, NotJarFileException {
        this(InputJarFile.getFileFromWorkingDirectory(workingDirectory, string), new FileLocation(string));
    }

    private InputJarFile(@Nonnull File file, @Nonnull FileLocation location) throws WrongPermissionException, NotFileException, NoSuchFileException, NotJarFileException {
        super(file, location, null);
        try {
            this.performChecks(FileOrDirectory.Existence.MUST_EXIST, 1, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        try {
            this.jarFile = new JarFile(file);
        }
        catch (IOException e) {
            throw new NotJarFileException(location, (Throwable)e);
        }
    }

    @Nonnull
    public JarFile getJarFile() {
        return this.jarFile;
    }

    @Nonnull
    public File getFile() {
        assert (this.file != null);
        return this.file;
    }
}

