/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.InputVFSCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.vfs.DirectFS;
import com.android.sched.vfs.GenericInputVFS;
import com.android.sched.vfs.InputVFS;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class DirectoryInputVFSCodec
extends InputVFSCodec
implements StringCodec<InputVFS> {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();
    @CheckForNull
    private String infoString;

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a directory (" + this.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "dir";
    }

    @Override
    @Nonnull
    public InputVFS checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            DirectFS vfs = new DirectFS(new Directory(context.getWorkingDirectory(), string, context.getRunnableHooks(), FileOrDirectory.Existence.MUST_EXIST, 1, this.change), 1);
            vfs.setInfoString(this.infoString);
            return new GenericInputVFS(vfs);
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotDirectoryException | WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }

    public DirectoryInputVFSCodec setInfoString(@Nonnull String infoString) {
        this.infoString = infoString;
        return this;
    }
}

