/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler.genetic;

import com.android.sched.item.Component;
import com.android.sched.scheduler.GroupPlanCandidate;
import com.android.sched.scheduler.ManagedRunnable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;

class RemoveUnsatisfiedRunnerMutation<T extends Component>
implements EvolutionaryOperator<GroupPlanCandidate<T>> {
    @Nonnull
    private final NumberGenerator<Probability> removeProbability;

    public RemoveUnsatisfiedRunnerMutation(@Nonnull NumberGenerator<Probability> removeProbability) {
        this.removeProbability = removeProbability;
    }

    @Nonnull
    public List<GroupPlanCandidate<T>> apply(List<GroupPlanCandidate<T>> selectedCandidates, Random rng) {
        ArrayList<GroupPlanCandidate<T>> mutatedCandidates = new ArrayList<GroupPlanCandidate<T>>(selectedCandidates.size());
        for (GroupPlanCandidate<T> candidate : selectedCandidates) {
            if (candidate.getSize() != 0 && ((Probability)this.removeProbability.nextValue()).nextEvent(rng)) {
                ArrayList<ManagedRunnable> newRunners = new ArrayList<ManagedRunnable>(candidate.getRunnables());
                if (candidate.getUnsatisfiedRunnerCount() > 0) {
                    int idx = rng.nextInt(candidate.getUnsatisfiedRunnerCount());
                    if (((ManagedRunnable)newRunners.get(idx = candidate.getIndexFromUnsatisfiedIndex(idx))).getProductions().isEmpty()) {
                        newRunners.remove(idx);
                    }
                }
                mutatedCandidates.add(new GroupPlanCandidate<T>(candidate, newRunners));
                continue;
            }
            mutatedCandidates.add(candidate);
        }
        return mutatedCandidates;
    }
}

