/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.schedulable.Schedulable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.SchedulableManager;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class SchedulableSet {
    @Nonnull
    private final SchedulableManager schedulableManager;
    @Nonnull
    private final Set<ManagedSchedulable> scheds = new TreeSet<ManagedSchedulable>(new SchedulableComparator());

    SchedulableSet(@Nonnull SchedulableManager manager) {
        this.schedulableManager = manager;
    }

    public boolean contains(@Nonnull Class<? extends Schedulable> sched) {
        for (ManagedSchedulable elt : this.scheds) {
            if (elt.getSchedulable() != sched) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(@Nonnull SchedulableSet set) {
        for (ManagedSchedulable elt : set.scheds) {
            if (this.contains(elt.getSchedulable())) continue;
            return false;
        }
        return true;
    }

    public void add(@Nonnull Class<? extends Schedulable> sched) {
        this.scheds.add(this.schedulableManager.getManagedSchedulable(sched));
    }

    public void addAll(@Nonnull SchedulableSet set) {
        this.scheds.addAll(set.scheds);
    }

    protected void add(@Nonnull ManagedSchedulable sched) {
        this.scheds.add(sched);
    }

    public void remove(@Nonnull Class<? extends Schedulable> sched) {
        for (ManagedSchedulable elt : this.scheds) {
            if (elt.getSchedulable() != sched) continue;
            this.scheds.remove(elt);
            return;
        }
    }

    public void removeAll(@Nonnull SchedulableSet set) {
        for (ManagedSchedulable elt : set.scheds) {
            this.remove(elt.getSchedulable());
        }
    }

    @Nonnegative
    public int getSize() {
        return this.scheds.size();
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('[');
        for (ManagedSchedulable sched : this.scheds) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(sched.getName());
        }
        sb.append(']');
        return new String(sb);
    }

    @Nonnull
    protected Set<ManagedSchedulable> getAll() {
        return this.scheds;
    }

    private static class SchedulableComparator
    implements Comparator<ManagedSchedulable>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private SchedulableComparator() {
        }

        @Override
        public int compare(@CheckForNull ManagedSchedulable o1, @CheckForNull ManagedSchedulable o2) {
            assert (o1 != null);
            assert (o2 != null);
            return o1.getName().compareTo(o2.getName());
        }
    }
}

