/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.frontend.java;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;

public class Variable {
    private static final int NO_LOCAL_IDX = -1;
    @Nonnull
    private final Type type;
    @Nonnull
    private final String id;
    @CheckForNull
    private final String signature;
    @Nonnull
    private String name;
    private boolean isThis;
    private boolean isParameter;
    private final boolean isSynthetic;
    private final int localIdx;

    public Variable(@Nonnull String id, @Nonnull String name, @Nonnull Type type, @CheckForNull String signature) {
        this(id, name, type, signature, -1, true);
    }

    public Variable(@Nonnull String id, @Nonnull String name, @Nonnull Type type, @CheckForNull String signature, int localIdx, boolean isSynthetic) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.signature = signature;
        this.localIdx = localIdx;
        this.isThis = false;
        this.isParameter = false;
        this.isSynthetic = isSynthetic;
    }

    public boolean hasLocalIndex() {
        return this.localIdx != -1;
    }

    @Nonnegative
    public int getLocalIndex() {
        assert (this.hasLocalIndex());
        return this.localIdx;
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public boolean hasSignature() {
        return this.signature != null;
    }

    @Nonnull
    public String getSignature() {
        assert (this.signature != null);
        return this.signature;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public boolean isThis() {
        return this.isThis;
    }

    public void setThis() {
        this.isThis = true;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void setParameter() {
        this.isParameter = true;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }
}

