/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.frontend.java;

import com.android.jill.backend.jayce.JayceWriter;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class SourceInfoWriter {
    @Nonnull
    protected final JayceWriter writer;
    @Nonnegative
    public static final int NO_LINE = 0;
    private static final String NO_FILENAME = null;
    @CheckForNull
    private String currentFileName;
    @Nonnegative
    private int currentLineNumber;

    public SourceInfoWriter(JayceWriter writer) {
        this.writer = writer;
    }

    public void writeDebugBegin(@Nonnull ClassNode cn) throws IOException {
        this.writeDebugBegin(cn, 0);
    }

    public void writeDebugBegin(@Nonnull ClassNode cn, @Nonnull FieldNode fn) throws IOException {
        this.writeUnknwonDebugBegin();
    }

    public void writeDebugBegin(@Nonnull ClassNode cn, int startLine) throws IOException {
        if (cn.sourceFile == null) {
            this.writeUnknwonDebugBegin();
        } else {
            this.writeFileNameIfDifferentFromCurrent(cn.sourceFile);
            this.writeLineIfDifferentFromCurrent(startLine);
        }
    }

    public void writeUnknwonDebugBegin() throws IOException {
        this.writeUnknowDebug();
    }

    public void writeDebugEnd(@Nonnull ClassNode cn) throws IOException {
        this.writeDebugEnd(cn, 0);
    }

    public void writeDebugEnd(@Nonnull ClassNode cn, @Nonnull FieldNode fn) throws IOException {
        this.writeUnknownDebugEnd();
    }

    public void writeDebugEnd(@Nonnull ClassNode cn, int endLine) throws IOException {
        if (cn.sourceFile == null) {
            this.writeUnknwonDebugBegin();
        } else {
            this.writeFileNameIfDifferentFromCurrent(cn.sourceFile);
            this.writeLineIfDifferentFromCurrent(endLine);
        }
    }

    public void writeUnknownDebugEnd() throws IOException {
        this.writeUnknowDebug();
    }

    private void writeUnknowDebug() throws IOException {
        if (this.currentFileName != null) {
            this.writeCurrentFileName(null);
            this.currentLineNumber = 0;
        }
    }

    private void writeFileNameIfDifferentFromCurrent(@Nonnull String fileName) throws IOException {
        if (!fileName.equals(this.currentFileName)) {
            this.writeCurrentFileName(fileName);
        }
    }

    private void writeCurrentFileName(@CheckForNull String fileName) throws IOException {
        this.writer.writeFileName(fileName);
        this.currentFileName = fileName;
    }

    private void writeLineIfDifferentFromCurrent(@Nonnegative int lineNumber) throws IOException {
        assert (this.currentFileName != NO_FILENAME || lineNumber == 0);
        if (lineNumber != this.currentLineNumber) {
            this.writeCurrentLine(lineNumber);
        }
    }

    private void writeCurrentLine(@Nonnegative int lineNumber) throws IOException {
        this.writer.writeCurrentLineInfo(lineNumber);
        this.currentLineNumber = lineNumber;
    }
}

