/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.frontend.java;

import com.android.jill.Options;
import com.android.jill.backend.jayce.JayceWriter;
import com.android.jill.backend.jayce.Token;
import com.android.jill.frontend.java.AnnotationWriter;
import com.android.jill.frontend.java.AsmHelper;
import com.android.jill.frontend.java.JillWriter;
import com.android.jill.frontend.java.MethodBodyWriter;
import com.android.jill.frontend.java.SourceInfoWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassNodeWriter
extends JillWriter {
    public static final int COMPILE_TIME_CONSTANT = 131072;
    @Nonnull
    private final AnnotationWriter annotWriter;
    private static final int ORDINAL_UNKNOWN = -1;
    @Nonnull
    private final Options options;

    public ClassNodeWriter(@Nonnull JayceWriter writer, @Nonnull SourceInfoWriter sourceInfoWriter, @Nonnull Options options) {
        super(writer, sourceInfoWriter);
        this.annotWriter = new AnnotationWriter(writer, sourceInfoWriter);
        this.options = options;
    }

    public void write(@Nonnull ClassNode cn) throws IOException {
        if (AsmHelper.isAnnotation(cn)) {
            this.writeAnnotation(cn);
        } else if (AsmHelper.isInterface(cn)) {
            this.writeInterface(cn);
        } else if (AsmHelper.isEnum(cn)) {
            this.writeEnum(cn);
        } else {
            this.writeClass(cn);
        }
    }

    private void writeEnum(@Nonnull ClassNode cn) throws IOException {
        this.sourceInfoWriter.writeDebugBegin(cn);
        this.writer.writeKeyword(Token.ENUM);
        this.writer.writeOpen();
        this.writer.writeInt(AsmHelper.getModifiers(cn));
        this.writer.writeId(AsmHelper.getDescriptor(cn));
        this.writer.writeId(cn.superName != null ? Type.getObjectType(cn.superName).getDescriptor() : null);
        this.writer.writeIds(AsmHelper.getDescriptorsFromInternalNames(cn.interfaces));
        this.writeEnclosingInformation(cn);
        this.writingInners(cn);
        this.writeEnumFields(cn);
        this.writeMethods(cn);
        this.annotWriter.writeAnnotations(cn);
        this.writer.writeOpenNodeList();
        this.writeGenericSignatureMarker(cn);
        this.writeSourceNameMarker(cn);
        this.writeThisRefTypeInfoMarker(cn);
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeDebugEnd(cn);
        this.writer.writeClose();
    }

    private void writeClass(@Nonnull ClassNode cn) throws IOException {
        this.sourceInfoWriter.writeDebugBegin(cn);
        this.writer.writeKeyword(Token.CLASS);
        this.writer.writeOpen();
        this.writer.writeInt(AsmHelper.getModifiers(cn));
        this.writer.writeId(AsmHelper.getDescriptor(cn));
        this.writer.writeId(cn.superName != null ? Type.getObjectType(cn.superName).getDescriptor() : null);
        this.writer.writeIds(AsmHelper.getDescriptorsFromInternalNames(cn.interfaces));
        this.writeEnclosingInformation(cn);
        this.writingInners(cn);
        this.writeFields(cn);
        this.writeMethods(cn);
        this.annotWriter.writeAnnotations(cn);
        this.writer.writeOpenNodeList();
        this.writeGenericSignatureMarker(cn);
        this.writeSourceNameMarker(cn);
        this.writeThisRefTypeInfoMarker(cn);
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeDebugEnd(cn);
        this.writer.writeClose();
    }

    private void writeInterface(@Nonnull ClassNode cn) throws IOException {
        assert (this.isPackageInfoIfNotAbstract(cn));
        this.sourceInfoWriter.writeDebugBegin(cn);
        this.writer.writeKeyword(Token.INTERFACE);
        this.writer.writeOpen();
        this.writer.writeInt(AsmHelper.getModifiers(cn) | 0x400);
        this.writer.writeId(AsmHelper.getDescriptor(cn));
        this.writer.writeIds(AsmHelper.getDescriptorsFromInternalNames(cn.interfaces));
        this.writeEnclosingInformation(cn);
        this.writingInners(cn);
        this.writeFields(cn);
        this.writeMethods(cn);
        this.annotWriter.writeAnnotations(cn);
        this.writer.writeOpenNodeList();
        this.writeGenericSignatureMarker(cn);
        this.writeSourceNameMarker(cn);
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeDebugEnd(cn);
        this.writer.writeClose();
    }

    private boolean isPackageInfoIfNotAbstract(@Nonnull ClassNode cn) {
        return (AsmHelper.getModifiers(cn) & 0x400) != 0 || cn.name.endsWith("package-info");
    }

    private void writeAnnotation(@Nonnull ClassNode cn) throws IOException {
        this.sourceInfoWriter.writeDebugBegin(cn);
        this.writer.writeKeyword(Token.ANNOTATION_TYPE);
        this.writer.writeOpen();
        this.annotWriter.writeRetentionPolicy(cn);
        this.writer.writeInt(AsmHelper.getModifiers(cn));
        this.writer.writeId(AsmHelper.getDescriptor(cn));
        this.writer.writeIds(AsmHelper.getDescriptorsFromInternalNames(cn.interfaces));
        this.writeEnclosingInformation(cn);
        this.writingInners(cn);
        this.writeFields(cn);
        this.writeAnnotationMethods(cn);
        this.annotWriter.writeAnnotations(cn);
        this.writer.writeOpenNodeList();
        this.writeGenericSignatureMarker(cn);
        this.writeSourceNameMarker(cn);
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeDebugEnd(cn);
        this.writer.writeClose();
    }

    private void writeThisRefTypeInfoMarker(@Nonnull ClassNode cn) throws IOException {
        String thisRefSignature = null;
        for (MethodNode mn : cn.methods) {
            if (AsmHelper.isStatic(mn) || mn.localVariables == null) continue;
            for (LocalVariableNode lvn : mn.localVariables) {
                if (!lvn.name.equals("this")) continue;
                if (thisRefSignature == null) {
                    thisRefSignature = lvn.signature;
                    continue;
                }
                assert (thisRefSignature.equals(lvn.signature));
            }
        }
        if (thisRefSignature != null) {
            this.writer.writeKeyword(Token.THIS_REF_TYPE_INFO);
            this.writer.writeOpen();
            this.writer.writeString(thisRefSignature);
            this.writer.writeClose();
        }
    }

    private void writeGenericSignatureMarker(@Nonnull ClassNode cn) throws IOException {
        if (AsmHelper.hasValidGenericSignature(cn)) {
            this.writer.writeKeyword(Token.GENERIC_SIGNATURE);
            this.writer.writeOpen();
            this.writer.writeString(cn.signature);
            this.writer.writeClose();
        }
    }

    private void writeSourceNameMarker(@Nonnull ClassNode cn) throws IOException {
        this.writer.writeKeyword(Token.SIMPLE_NAME);
        this.writer.writeOpen();
        this.writer.writeString(AsmHelper.getSourceName(cn));
        this.writer.writeClose();
    }

    private void writeGenericSignatureMarker(@Nonnull FieldNode fn) throws IOException {
        if (AsmHelper.hasValidGenericSignature(fn)) {
            this.writer.writeKeyword(Token.GENERIC_SIGNATURE);
            this.writer.writeOpen();
            this.writer.writeString(fn.signature);
            this.writer.writeClose();
        }
    }

    private void writeFields(@Nonnull ClassNode cn) throws IOException {
        this.writer.writeOpenNodeList();
        for (FieldNode fn : cn.fields) {
            this.writeField(cn, fn, Token.FIELD);
        }
        this.writer.writeCloseNodeList();
    }

    private void writeEnumFields(@Nonnull ClassNode cn) throws IOException {
        this.writer.writeOpenNodeList();
        for (FieldNode fn : cn.fields) {
            if (!AsmHelper.isEnumField(fn)) {
                this.writeField(cn, fn, Token.FIELD);
                continue;
            }
            this.writeField(cn, fn, Token.ENUM_FIELD);
        }
        this.writer.writeCloseNodeList();
    }

    private void writeField(@Nonnull ClassNode cn, @Nonnull FieldNode fn, @Nonnull Token kind) throws IOException {
        assert (kind == Token.FIELD || kind == Token.ENUM_FIELD);
        this.sourceInfoWriter.writeDebugBegin(cn, fn);
        this.writer.writeKeyword(kind);
        this.writer.writeOpen();
        this.writer.writeInt(fn.value != null ? AsmHelper.getModifiers(fn) | 0x20000 : AsmHelper.getModifiers(fn));
        this.writer.writeString(fn.desc);
        this.writer.writeString(fn.name);
        this.writeFieldValue(cn, fn);
        if (kind == Token.ENUM_FIELD) {
            this.writer.writeInt(-1);
        }
        this.annotWriter.writeAnnotations(fn);
        this.writer.writeOpenNodeList();
        this.writeGenericSignatureMarker(fn);
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeDebugEnd(cn, fn);
        this.writer.writeClose();
    }

    private void writeFieldValue(@Nonnull ClassNode cn, @Nonnull FieldNode fn) throws IOException {
        if (AsmHelper.isStatic(fn)) {
            Object value = fn.value;
            if (value instanceof Integer) {
                int intValue = (Integer)value;
                if (fn.desc.equals("Z")) {
                    this.writeValue(intValue != 0);
                } else if (fn.desc.equals("B")) {
                    this.writeValue((byte)intValue);
                } else if (fn.desc.equals("C")) {
                    this.writeValue((char)intValue);
                } else if (fn.desc.equals("S")) {
                    this.writeValue((short)intValue);
                } else {
                    this.writeValue(intValue);
                }
            } else if (value instanceof Long) {
                this.writeValue((Long)value);
            } else if (value instanceof Float) {
                this.writeValue(((Float)value).floatValue());
            } else if (value instanceof Double) {
                this.writeValue((Double)value);
            } else if (value instanceof String) {
                this.writeValue((String)value);
            } else {
                this.writer.writeNull();
            }
        } else {
            this.writer.writeNull();
        }
    }

    private void writeAnnotationMethods(@Nonnull ClassNode cn) throws IOException {
        assert (AsmHelper.isAnnotation(cn));
        this.writer.writeOpenNodeList();
        for (MethodNode mn : cn.methods) {
            new MethodBodyWriter(this.writer, this.annotWriter, cn, mn, this.sourceInfoWriter, this.options).write();
        }
        this.writer.writeCloseNodeList();
    }

    private void writeMethods(@Nonnull ClassNode cn) throws IOException {
        this.writer.writeOpenNodeList();
        ArrayList<MethodNode> additionalMethods = new ArrayList<MethodNode>();
        for (MethodNode mn : cn.methods) {
            MethodBodyWriter mbw = new MethodBodyWriter(this.writer, this.annotWriter, cn, mn, this.sourceInfoWriter, this.options);
            mbw.write();
            additionalMethods.addAll(mbw.getAdditionalMethods());
        }
        for (MethodNode mn : additionalMethods) {
            new MethodBodyWriter(this.writer, this.annotWriter, cn, mn, this.sourceInfoWriter, this.options).write();
        }
        this.writer.writeCloseNodeList();
    }

    private void writingInners(@Nonnull ClassNode cn) throws IOException {
        List<InnerClassNode> innerClasses = cn.innerClasses;
        ArrayList<String> innerIds = new ArrayList<String>();
        if (innerClasses != null) {
            Object matchingInnerClassNode = null;
            for (InnerClassNode innerClassNode : innerClasses) {
                if (innerClassNode.outerName == null || !innerClassNode.outerName.equals(cn.name) || innerClassNode.name == null) continue;
                innerIds.add(Type.getObjectType(innerClassNode.name).getDescriptor());
            }
        }
        this.writer.writeIds(innerIds);
    }

    private void writeEnclosingInformation(@Nonnull ClassNode cn) throws IOException {
        List<InnerClassNode> innerClasses = cn.innerClasses;
        if (innerClasses != null) {
            InnerClassNode matchingInnerClassNode = null;
            for (InnerClassNode innerClassNode : innerClasses) {
                if (!innerClassNode.name.equals(cn.name)) continue;
                matchingInnerClassNode = innerClassNode;
                break;
            }
            if (matchingInnerClassNode != null) {
                if (cn.outerMethod != null) {
                    assert (cn.outerMethodDesc != null);
                    if (!AsmHelper.isInterface(cn) && !AsmHelper.isAnnotation(cn)) {
                        this.writer.writeId(Type.getObjectType(cn.outerClass).getDescriptor());
                        this.writer.writeId(Type.getObjectType(cn.outerClass).getDescriptor());
                        this.writer.writeId(cn.outerMethod + cn.outerMethodDesc);
                    } else {
                        this.writer.writeId(null);
                    }
                } else {
                    String outerClassName;
                    String string = outerClassName = cn.outerClass != null ? cn.outerClass : matchingInnerClassNode.outerName;
                    if (outerClassName != null) {
                        this.writer.writeId(Type.getObjectType(outerClassName).getDescriptor());
                    } else {
                        this.writer.writeId(null);
                    }
                    if (!AsmHelper.isInterface(cn) && !AsmHelper.isAnnotation(cn)) {
                        this.writer.writeId(null);
                        this.writer.writeId(null);
                    }
                }
            } else {
                this.writer.writeId(null);
                if (!AsmHelper.isInterface(cn) && !AsmHelper.isAnnotation(cn)) {
                    this.writer.writeId(null);
                    this.writer.writeId(null);
                }
            }
        } else {
            this.writer.writeId(null);
            if (!AsmHelper.isInterface(cn) && !AsmHelper.isAnnotation(cn)) {
                this.writer.writeId(null);
                this.writer.writeId(null);
            }
        }
    }
}

