/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill;

import com.android.jill.IllegalOptionsException;
import com.android.jill.Jill;
import com.android.jill.JillException;
import com.android.jill.Options;
import com.android.sched.util.config.cli.TokenIterator;
import com.android.sched.util.file.CannotListDirException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileOrDirectoryException;
import com.android.sched.util.file.SchedIOException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.NoLocation;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;

public class Main {
    public static void main(@Nonnull String[] args) {
        Options options = null;
        try {
            options = Main.getOptions(args);
            if (options.askForHelp()) {
                Main.printUsage(System.out);
                System.exit(0);
            }
            if (options.askForVersion()) {
                System.out.println("Jill");
                System.out.println("Version: " + Jill.getVersion().getVerboseVersion() + '.');
                System.exit(0);
            }
            System.exit(Main.runJill(System.err, options));
        }
        catch (CmdLineException e) {
            CmdLineParser parser;
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            }
            if ((parser = e.getParser()) != null) {
                Main.printUsage(System.out);
            } else {
                System.err.println("Try --help for help");
            }
            System.exit(2);
        }
        catch (SchedIOException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        System.exit(1);
    }

    protected static int runJill(@Nonnull PrintStream err, @Nonnull Options options) {
        try {
            Jill.process(options);
        }
        catch (JillException e) {
            err.println("Binary transformation of " + options.getBinaryFile().getPath() + " failed: " + e.getMessage());
            if (options.isVerbose()) {
                e.printStackTrace(err);
            }
            return 3;
        }
        return 0;
    }

    @Nonnull
    public static Options getOptions(@Nonnull String[] args) throws CmdLineException, CannotListDirException, NoSuchElementException, WrongPermissionException, NoSuchFileException, NotFileOrDirectoryException, CannotReadException {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser(options, ParserProperties.defaults().withUsageWidth(100));
        TokenIterator iterator = new TokenIterator(new NoLocation(), args);
        ArrayList<String> list = new ArrayList<String>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        parser.parseArgument(list);
        parser.stopOptionParsing();
        try {
            options.checkValidity();
        }
        catch (IllegalOptionsException e) {
            throw new CmdLineException(parser, e.getMessage(), e);
        }
        return options;
    }

    protected static void printUsage(@Nonnull PrintStream printStream) {
        CmdLineParser parser = new CmdLineParser(new Options(), ParserProperties.defaults().withUsageWidth(100));
        printStream.println("Usage: <options> <class files to be transformed contained recursively in directories or in a zip/jar file>");
        printStream.println();
        printStream.println("Options:");
        parser.printUsage(printStream);
    }
}

