/$ VulnDB.h

/*
AUSTIN - A Palm OS Security Scanner.
Copyright (C) 2003  @stake, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// Manages the PalmScan vulnerability database

#define	VULN_DB			"AUSTIN Vuln DB"
#define	VULN_FIRSTOPEN	0
#define VULN_REOPEN		1

#define	VULN_SERVER		0
#define VULN_URI		1
#define VULN_DOS		2
#define VULN_METHOD		3
#define VULN_MATCH		4
#define VULN_IMPACT		5
#define VULN_DESC		6
#define VULN_SELECTED	7

#define	VULN_RETCODECHECK	"R::"
#define VULN_MATCHCHECK		"M::"
#define	VULN_CHECKLEN		3		// the length of the other CHECK #defs

int _Vuln_dbtotrecs;
int _Vuln_dbcurrec;
string _Vuln_dbrec[8];


@doc "Open the vuln db, find out how many records it has.";
openVulnDB(int mode) {
	if (DBopen(VULN_DB) != 0) return false;
	if (mode == VULN_FIRSTOPEN) {
		_Vuln_dbtotrecs = DBinfo(2, 0);
		_Vuln_dbcurrec = 0;
	}
	return true;
}

@doc "Reads the current vuln from the DB.";
readVuln() {
	int res;
	
	if (_Vuln_dbcurrec == _Vuln_dbtotrecs) return false;
	writeln("readVuln: currec=" + _Vuln_dbcurrec);
	res = DBgetrec(_Vuln_dbcurrec, _Vuln_dbrec);
	_Vuln_dbcurrec++;
	if (res == 0) return true;
	else return false;
}

@doc "Print vulnerability information. Used for debugging.";
printVulnDebug() {
	writeln("Server:\t" + _Vuln_dbrec[VULN_SERVER]);
	writeln("URI:\t\t" + _Vuln_dbrec[VULN_URI]);
	writeln("DoS:\t\t" + _Vuln_dbrec[VULN_DOS]);
	writeln("Method:\t" + _Vuln_dbrec[VULN_METHOD]);
	writeln("Match:\t" + _Vuln_dbrec[VULN_MATCH]);
	writeln("Impact:\t" + _Vuln_dbrec[VULN_IMPACT]);
	writeln("Desc:\t" + _Vuln_dbrec[VULN_DESC]);
	writeln("Selected:\t" + _Vuln_dbrec[VULN_SELECTED]);
	writeln("----- END VULN -----\n");
}

@doc "Stub function in case DBs have to be explicitly closed in the future.";
closeVulnDB() {
	return true;
}
