/*
 *  © Darren McDonald 2010
 *
 *  This file is part of athena-ssl-cipher-check.
 *
 *  athena-ssl-cipher-check is free software: you can redistribute it
 *  and/or modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, either version 3 of the License,
 *  or (at your option) any later version.
 *
 *  athena-ssl-cipher-check is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 *  Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with athena-ssl-cipher-check. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

package athenasslciphercheck;

import java.io.IOException;

public class TimeHelper {
    public static void getTime( byte[] array )
    {
        long systemTimeInSeconds = System.currentTimeMillis()/1000;
        array[3] = (byte)  systemTimeInSeconds;
        array[2] = (byte) ( systemTimeInSeconds >> 8 );
        array[1] = (byte) ( systemTimeInSeconds >> 16 );
        array[0] = (byte) ( systemTimeInSeconds >> 24 );
    }

    public static String getHexString(byte[] b)
    {

            String result = "";
            for (int i=0; i < b.length; i++) {
                result +=
                Integer.toString( ( b[i] & 0xff ) + 0x100, 16).substring( 1 );
            }
            return result;
    }

}
