/*
 * Decompiled with CFR 0.152.
 */
package athenasslciphercheck;

import athenasslciphercheck.Cipher;
import athenasslciphercheck.CipherListWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class ClientCheck {
    int port;

    public ClientCheck(int p) {
        this.port = p;
        this.check();
    }

    private void check() {
        System.out.println("");
        try {
            CipherListWrapper cipherListWrapper = new CipherListWrapper();
            cipherListWrapper.loadCiphers();
            int type = 0;
            ServerSocket sconn = null;
            Socket conn = null;
            sconn = new ServerSocket(this.port);
            conn = sconn.accept();
            InputStream in = conn.getInputStream();
            OutputStream out = conn.getOutputStream();
            byte[] tmp = new byte[2];
            byte[] tmp2 = new byte[1];
            in.read(tmp);
            if (tmp[0] == 22) {
                in.read(tmp);
                if (tmp[0] == 0) {
                    type = 2;
                    System.out.println("SSLv3 Connection Received");
                } else if (tmp[0] == 1) {
                    type = 3;
                    System.out.println("TLSv1 Connection Received");
                } else {
                    System.out.println("Unexpected SSL version detected, but I'll give it a shot anyway...");
                }
                in.read(tmp);
                in.read(tmp);
                in.read(tmp2);
                in.read(tmp);
                for (int i = 0; i < 16; ++i) {
                    in.read(tmp);
                }
                in.read(tmp2);
                int sessionLength = tmp2[0];
                for (int i = 0; i < sessionLength; ++i) {
                    in.read(tmp2);
                }
                in.read(tmp);
                int cipherLength = tmp[0] * 256 + tmp[1];
                byte[] cipherCode = new byte[2];
                for (int i = 0; i < cipherLength / 2; ++i) {
                    in.read(cipherCode);
                    Cipher c = cipherListWrapper.lookUpCipher(cipherCode);
                    System.out.println(c.getDesc());
                }
            } else if (tmp[0] == -128) {
                System.out.println("SSLv2 Connection Received");
            } else {
                System.out.println("Unidentified header, are you sure this is a SSL/TLS client?");
            }
            conn.close();
            sconn.close();
        }
        catch (IOException ex) {
            System.out.println("");
            System.out.println("Unable to open listener on port " + this.port);
            System.out.println(ex.getMessage());
        }
    }
}

