/*
 * Decompiled with CFR 0.152.
 */
package athenasslciphercheck;

import athenasslciphercheck.Cipher;
import athenasslciphercheck.Results;
import athenasslciphercheck.connection;
import athenasslciphercheck.sslv2MessageFactory;

public class ssl2CipherCheck {
    public int resetCount = 0;
    public int timedOutCount = 0;
    public int unidentifiedCount = 0;
    public int rejectedCount = 0;

    ssl2CipherCheck() {
    }

    public void check() {
        byte[] helloMessage = new byte[30];
        byte[] cipherSpec = new byte[]{1, 0, -128, 2, 0, -128, 3, 0, -128, 4, 0, -128, 5, 0, -128, 6, 0, 64, 7, 0, -64, 8, 0, -128};
        int timeOutCounter = 0;
        for (int i = 0; i < 8; ++i) {
            int x;
            sslv2MessageFactory.makeMessage(helloMessage, cipherSpec, i * 3);
            connection conn = new connection();
            if (!conn.connect()) break;
            conn.send(helloMessage);
            int tmp = 0;
            int length1 = conn.recv();
            if (length1 == -3) {
                ++timeOutCounter;
                break;
            }
            int length2 = conn.recv();
            tmp = conn.recv();
            tmp = conn.recv();
            tmp = conn.recv();
            tmp = conn.recv();
            tmp = conn.recv();
            int certL = conn.recv() * 256;
            certL += conn.recv();
            int cipherL = conn.recv() * 256;
            cipherL += conn.recv();
            tmp = conn.recv();
            tmp = conn.recv();
            for (x = 0; x < certL; ++x) {
                tmp = conn.recv();
            }
            for (x = 0; x < cipherL / 3; ++x) {
                int cpr1 = conn.recv();
                int cpr2 = conn.recv();
                int cpr3 = conn.recv();
                block13: for (int n = 0; n < cipherSpec.length; n += 3) {
                    if (cipherSpec[n] != (byte)cpr1 || cipherSpec[n + 1] != (byte)cpr2 || cipherSpec[n + 2] != (byte)cpr3) continue;
                    cipherSpec[n] = 0;
                    cipherSpec[n + 1] = 0;
                    cipherSpec[n + 2] = 0;
                    switch (n / 3) {
                        case 0: {
                            Results.addResultLine(new Cipher("SSL_CK_WITH_RC4_128_MD5", null, 128, 0), "SSLv2");
                            continue block13;
                        }
                        case 1: {
                            Results.addResultLine(new Cipher("SSL_CK_WITH_RC4_128_EXPORT40_MD5", null, 40, 0), "SSLv2");
                            continue block13;
                        }
                        case 2: {
                            Results.addResultLine(new Cipher("SSL_CK_WITH_RC2_128_CBC_MD5", null, 128, 0), "SSLv2");
                            continue block13;
                        }
                        case 3: {
                            Results.addResultLine(new Cipher("SSL_CK_WITH_RC2_128_CBC_EXPORT40_MD5", null, 40, 0), "SSLv2");
                            continue block13;
                        }
                        case 4: {
                            Results.addResultLine(new Cipher("SSL_CK_WITH_IDEA_128_CBC_MD5", null, 128, 0), "SSLv2");
                            continue block13;
                        }
                        case 5: {
                            Results.addResultLine(new Cipher("SSL_CK_WITH_DES_64_CBC_MD5", null, 56, 0), "SSLv2");
                            continue block13;
                        }
                        case 6: {
                            Results.addResultLine(new Cipher("SSL_CK_WITH_DES_192_EDE3_CBC_MD5", null, 168, 0), "SSLv2");
                            continue block13;
                        }
                        case 7: {
                            Results.addResultLine(new Cipher("SSL_CK_WITH_RC4_64_MD5", null, 64, 0), "SSLv2");
                            continue block13;
                        }
                        default: {
                            Results.addResultLine(new Cipher("Unknown SSLv2 Cipher found", null, 0, 0), "SSLv2");
                        }
                    }
                }
            }
            conn.close();
        }
    }

    private void printStats() {
        if (this.resetCount == 0 && this.timedOutCount == 0 && this.unidentifiedCount == 0 && this.rejectedCount == 0) {
            return;
        }
        System.out.println("");
        boolean first = true;
        if (this.resetCount > 0) {
            System.out.print(this.resetCount + " connections reset");
            first = false;
        }
        if (this.timedOutCount > 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print(this.resetCount + " connections reset");
            first = false;
        }
        if (this.unidentifiedCount > 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print(this.unidentifiedCount + " connections reset");
            first = false;
        }
        if (this.rejectedCount > 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print(this.rejectedCount + " connections reset");
            first = false;
        }
    }
}

