/*
 * Decompiled with CFR 0.152.
 */
package athenasslciphercheck;

import athenasslciphercheck.ClientCheck;
import athenasslciphercheck.Results;
import athenasslciphercheck.Settings;
import athenasslciphercheck.connection;
import athenasslciphercheck.ssl2CipherCheck;
import athenasslciphercheck.tlsHeuristics;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Main {
    public static void main(String[] args) {
        System.out.println("Athena SSL Cipher Check, v0.6.2, Copyright \u00a9 2010 Darren McDonald\nThis program comes with ABSOLUTELY NO WARRANTY. This is free\nsoftware, and you are welcome to redistribute it under certain\nconditions. See the LICENSE file for details.");
        System.out.println("Send bugs and details of unknown ciphers to athena@dmcdonald.net");
        if (args.length == 1 && args[0].equals("--gui")) {
            System.out.println("Real men use a CLI");
        } else {
            if (args.length == 0) {
                Main.printUsage();
                return;
            }
            Settings settings = Main.parseCommandLine(args);
            if (settings == null) {
                Main.printUsage();
                return;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String date = sdf.format(Calendar.getInstance().getTime());
            if (!settings.getClient()) {
                connection.settings = settings;
                System.out.println("");
                System.out.println("Scanning " + settings.getHost() + ":" + settings.getPort() + " at " + date);
                System.out.println("");
                System.out.println("SSLv2 Ciphers");
                ssl2CipherCheck ssl2 = new ssl2CipherCheck();
                ssl2.check();
                tlsHeuristics tls = new tlsHeuristics(settings);
                tls.checkTlsCiphers();
            } else {
                System.out.println("");
                System.out.println("Listening on port 0.0.0.0:" + settings.getPort() + " for an incoming SSL connection, " + date);
                ClientCheck tmp = new ClientCheck(settings.getPort());
            }
            if (settings.getLazy()) {
                System.out.println(Results.getLazy());
            }
            if (Results.getCount() == 0 && !settings.getClient()) {
                System.out.println("");
                System.out.println("No SSLv3/TLSv1 results? Try --safe mode. See --help for details.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Settings parseCommandLine(String[] args) {
        Settings set = new Settings();
        set.setThrottle(0);
        set.setTimeout(5000);
        set.setBasicAuth("");
        set.setRetrys(3);
        set.setClient(false);
        String host = "";
        String port = "";
        int pType = 0;
        String pHost = "";
        String pPort = "";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("--proxy")) {
                    if (i + 1 >= args.length) return null;
                    if (args[i + 1].equalsIgnoreCase("HTTP")) {
                        pType = 1;
                    } else {
                        if (!args[i + 1].equalsIgnoreCase("DIRECT")) return null;
                        pType = 0;
                    }
                    ++i;
                    continue;
                }
                if (args[i].equals("--phost")) {
                    if (i + 1 >= args.length) {
                        return null;
                    }
                    pHost = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("--pport")) {
                    if (i + 1 >= args.length) {
                        return null;
                    }
                    pPort = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("--timeout") || args[i].equals("-t")) {
                    if (i + 1 >= args.length) return null;
                    if (Integer.parseInt(args[i + 1]) < 1) {
                        return null;
                    }
                    set.setTimeout(Integer.parseInt(args[i + 1]));
                    ++i;
                    continue;
                }
                if (args[i].equals("--delay") || args[i].equals("-d")) {
                    if (i + 1 >= args.length) return null;
                    if (Integer.parseInt(args[i + 1]) < 0) {
                        return null;
                    }
                    set.setThrottle(Integer.parseInt(args[i + 1]));
                    ++i;
                    continue;
                }
                if (args[i].equals("--retrys") || args[i].equals("-r")) {
                    if (i + 1 >= args.length) {
                        return null;
                    }
                    set.setRetrys(i);
                    ++i;
                    continue;
                }
                if (args[i].equals("--client") || args[i].equals("-c")) {
                    set.setClient(true);
                    continue;
                }
                if (args[i].equals("--basicauth")) {
                    if (i + 1 >= args.length) {
                        return null;
                    }
                    set.setBasicAuth(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("--help")) {
                    Main.printHelp();
                    return null;
                }
                if (args[i].equals("-l") || args[i].equals("--lazy")) {
                    set.setLazy();
                    continue;
                }
                if (!args[i].equals("-s") && !args[i].equals("--safe")) continue;
                set.setSafe();
                continue;
            }
            if (host.length() == 0) {
                if (set.getClient()) {
                    port = args[i];
                    Results.setPort(port);
                    continue;
                }
                host = args[i];
                Results.setHost(host);
                continue;
            }
            if (port.length() != 0) return null;
            port = args[i];
            Results.setPort(port);
        }
        if (port.length() == 0) {
            return null;
        }
        try {
            set.setPort(Integer.parseInt(port));
        }
        catch (NumberFormatException ex) {
            return null;
        }
        if (!set.getClient()) {
            set.setHost(host);
        }
        if (pType == 0) return set;
        if (pHost.length() == 0 || pPort.length() == 0 || Integer.parseInt(pPort) < 1) {
            return null;
        }
        set.setProxyHost(pHost);
        set.setProxyPort(Integer.parseInt(pPort));
        set.setProxyType(pType);
        return set;
    }

    public static void printUsage() {
        System.out.println();
        System.out.println("Basic Usage : java -jar athena-ssl-cipher-check [ip] [port]");
        System.out.println("         or : java -jar athena-ssl-cipher-check --client [port]");
        System.out.println("         or : java -jar athena-ssl-cipher-check --help");
    }

    public static void printHelp() {
        System.out.println();
        System.out.println("athena-ssl-cipher-check [options] [ip | hostname] [port] ");
        System.out.println("");
        System.out.println("Timing Opitons");
        System.out.println("         --timeout, -t [milliseconds]");
        System.out.println("                 Specify how long a request should wait for a reply");
        System.out.println("                 Default: 5000");
        System.out.println("         --delay, -d [milliseconds]");
        System.out.println("                 Specify how long to sleep for between sending requests");
        System.out.println("                 Default: 0");
        System.out.println("         --retrys, -r [retrys]");
        System.out.println("                 Specifies how many retrys the system will perform");
        System.out.println("                 Default: 3");
        System.out.println("         --safe, -s");
        System.out.println("                 Safe mode, sends cipher lists in smaller chunks which");
        System.out.println("                 is required by some SSL services written by developers");
        System.out.println("                 who havnt actually read any of the RFCs. If your results");
        System.out.println("                 come back without any SSlv3/TLS ciphers, try this mode.");
        System.out.println("                 This mode is slower than a normal scan.");
        System.out.println("");
        System.out.println("Proxy Support - Required Options");
        System.out.println("         --proxy [proxy type]");
        System.out.println("                 Supported Options: HTTP");
        System.out.println("         --phost [proxy ip/host]");
        System.out.println("         --pport [proxy port]");
        System.out.println("");
        System.out.println("Proxy Support - Authentication Options");
        System.out.println("         --basicauth [username:password] | *");
        System.out.println("                 * for interactive login");
        System.out.println("");
        System.out.println("Client Cipher Check");
        System.out.println("         --client, -c [port]");
        System.out.println("                 If client mode is used all other options will be ignored");
        System.out.println("");
        System.out.println("Output Options");
        System.out.println("         --lazy, -l");
        System.out.println("                 Lazy Consultant Mode, lists any ciphers which should be");
        System.out.println("                 disabled by issue. This is based on my understanding and");
        System.out.println("                 opinion. I could be completly wrong.");
    }
}

