/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ClassNameParser;
import proguard.util.StringMatcher;

public class MemberDescriptorFilter
implements MemberVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final MemberVisitor memberVisitor;

    public MemberDescriptorFilter(String string, MemberVisitor memberVisitor) {
        this(new ClassNameParser().parse(string), memberVisitor);
    }

    public MemberDescriptorFilter(StringMatcher stringMatcher, MemberVisitor memberVisitor) {
        this.regularExpressionMatcher = stringMatcher;
        this.memberVisitor = memberVisitor;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.accepted(programField.getDescriptor(programClass))) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.accepted(programMethod.getDescriptor(programClass))) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.accepted(libraryField.getDescriptor(libraryClass))) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.accepted(libraryMethod.getDescriptor(libraryClass))) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private boolean accepted(String string) {
        return this.regularExpressionMatcher.matches(string);
    }
}

