/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

public class CenteredIcon
implements Icon {
    private final Icon myIcon;
    private final int myWidth;
    private final int myHight;
    private final boolean myCenteredInComponent;

    public CenteredIcon(Icon icon) {
        this(icon, icon.getIconWidth(), icon.getIconHeight(), true);
    }

    public CenteredIcon(Icon icon, int width, int height) {
        this(icon, width, height, true);
    }

    public CenteredIcon(Icon icon, int width, int height, boolean centeredInComponent) {
        this.myIcon = icon;
        this.myWidth = width;
        this.myHight = height;
        this.myCenteredInComponent = centeredInComponent;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int offsetY;
        int offsetX;
        if (this.myCenteredInComponent) {
            Dimension size = c.getSize();
            offsetX = size.width / 2 - this.myIcon.getIconWidth() / 2;
            offsetY = size.height / 2 - this.myIcon.getIconHeight() / 2;
        } else {
            offsetX = (this.myWidth - this.myIcon.getIconWidth()) / 2;
            offsetY = (this.myHight - this.myIcon.getIconHeight()) / 2;
        }
        this.myIcon.paintIcon(c, g, x + offsetX, y + offsetY);
    }

    @Override
    public int getIconWidth() {
        return this.myWidth;
    }

    @Override
    public int getIconHeight() {
        return this.myHight;
    }
}

