/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.BoundedScheduledExecutorService;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.NotNull;

public class AppExecutorUtil {
    @NotNull
    public static ScheduledExecutorService getAppScheduledExecutorService() {
        ScheduledExecutorService scheduledExecutorService = AppScheduledExecutorService.getInstance();
        if (scheduledExecutorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppExecutorUtil", "getAppScheduledExecutorService"));
        }
        return scheduledExecutorService;
    }

    @NotNull
    public static ExecutorService getAppExecutorService() {
        ExecutorService executorService = ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).backendExecutorService;
        if (executorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppExecutorUtil", "getAppExecutorService"));
        }
        return executorService;
    }

    @NotNull
    public static ScheduledExecutorService createBoundedScheduledExecutorService(@NotNull String name, int maxSimultaneousTasks) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/concurrency/AppExecutorUtil", "createBoundedScheduledExecutorService"));
        }
        BoundedScheduledExecutorService boundedScheduledExecutorService = new BoundedScheduledExecutorService(name, AppExecutorUtil.getAppExecutorService(), maxSimultaneousTasks);
        if (boundedScheduledExecutorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppExecutorUtil", "createBoundedScheduledExecutorService"));
        }
        return boundedScheduledExecutorService;
    }

    @NotNull
    public static ExecutorService createBoundedApplicationPoolExecutor(@NotNull String name, int maxThreads) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/concurrency/AppExecutorUtil", "createBoundedApplicationPoolExecutor"));
        }
        BoundedTaskExecutor boundedTaskExecutor = new BoundedTaskExecutor(name, AppExecutorUtil.getAppExecutorService(), maxThreads);
        if (boundedTaskExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppExecutorUtil", "createBoundedApplicationPoolExecutor"));
        }
        return boundedTaskExecutor;
    }
}

