/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringChangeUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.refactoring.util.ChangeUtil");

    @Nullable
    private static String getMethodExpressionName(@Nullable PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)element).getMethodExpression();
        return methodExpression.getReferenceName();
    }

    public static boolean isSuperOrThisMethodCall(@Nullable PsiElement element) {
        String name = RefactoringChangeUtil.getMethodExpressionName(element);
        return "super".equals(name) || "this".equals(name);
    }

    public static boolean isSuperMethodCall(@Nullable PsiElement element) {
        String name = RefactoringChangeUtil.getMethodExpressionName(element);
        return "super".equals(name);
    }

    public static PsiType getTypeByExpression(PsiExpression expr) {
        PsiType type;
        PsiType psiType = type = expr != null ? expr.getType() : null;
        if (type == null) {
            PsiExpression[] initializers;
            if (expr instanceof PsiArrayInitializerExpression && (initializers = ((PsiArrayInitializerExpression)expr).getInitializers()).length > 0) {
                PsiType initType = RefactoringChangeUtil.getTypeByExpression(initializers[0]);
                if (initType == null) {
                    return null;
                }
                return initType.createArrayType();
            }
            if (expr instanceof PsiReferenceExpression && PsiUtil.isOnAssignmentLeftHand(expr)) {
                return RefactoringChangeUtil.getTypeByExpression(((PsiAssignmentExpression)expr.getParent()).getRExpression());
            }
            return null;
        }
        PsiClass refClass = PsiUtil.resolveClassInType(type);
        if (refClass instanceof PsiAnonymousClass) {
            type = ((PsiAnonymousClass)refClass).getBaseClassType();
        }
        return GenericsUtil.getVariableTypeByExpressionType(type);
    }

    public static PsiReferenceExpression qualifyReference(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiMember member, @Nullable PsiClass qualifyingClass) throws IncorrectOperationException {
        PsiReferenceExpression expressionFromText;
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/refactoring/util/RefactoringChangeUtil", "qualifyReference"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/util/RefactoringChangeUtil", "qualifyReference"));
        }
        PsiManager manager = referenceExpression.getManager();
        PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiMethodCallExpression.class, true);
        while (methodCallExpression != null) {
            if (RefactoringChangeUtil.isSuperOrThisMethodCall(methodCallExpression)) {
                return referenceExpression;
            }
            methodCallExpression = PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiMethodCallExpression.class, true);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        if (qualifyingClass == null) {
            PsiClass parentClass = PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
            PsiClass containingClass = member.getContainingClass();
            if (parentClass != null && !InheritanceUtil.isInheritorOrSelf(parentClass, containingClass, true)) {
                while (parentClass != null && !InheritanceUtil.isInheritorOrSelf(parentClass, containingClass, true)) {
                    parentClass = PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, true);
                }
                LOG.assertTrue(parentClass != null);
                expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("A.this." + member.getName(), null);
                ((PsiThisExpression)expressionFromText.getQualifierExpression()).getQualifier().replace(factory.createClassReferenceElement(parentClass));
            } else {
                PsiModifierListOwner staticElement = PsiUtil.getEnclosingStaticElement(referenceExpression, null);
                if (staticElement != null && containingClass != null && !PsiTreeUtil.isAncestor(staticElement, containingClass, false)) {
                    return referenceExpression;
                }
                expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("this." + member.getName(), null);
            }
        } else {
            expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("A." + member.getName(), null);
            expressionFromText.setQualifierExpression(factory.createReferenceExpression(qualifyingClass));
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(manager.getProject());
        expressionFromText = (PsiReferenceExpression)codeStyleManager.reformat(expressionFromText);
        return (PsiReferenceExpression)referenceExpression.replace(expressionFromText);
    }

    public static PsiClass getThisClass(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/refactoring/util/RefactoringChangeUtil", "getThisClass"));
        }
        PsiElement parent = place.getContext();
        if (parent == null) {
            return null;
        }
        PsiElement prev = null;
        do {
            if (parent instanceof PsiClass && (!(parent instanceof PsiAnonymousClass) || ((PsiAnonymousClass)parent).getArgumentList() != prev)) {
                return (PsiClass)parent;
            }
            prev = parent;
        } while ((parent = parent.getContext()) != null);
        return null;
    }

    static <T extends PsiQualifiedExpression> T createQualifiedExpression(@NotNull PsiManager manager, PsiClass qualifierClass, @NotNull String qName) throws IncorrectOperationException {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/refactoring/util/RefactoringChangeUtil", "createQualifiedExpression"));
        }
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/refactoring/util/RefactoringChangeUtil", "createQualifiedExpression"));
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        if (qualifierClass != null) {
            PsiQualifiedExpression qualifiedThis = (PsiQualifiedExpression)factory.createExpressionFromText("q." + qName, null);
            qualifiedThis = (PsiQualifiedExpression)CodeStyleManager.getInstance(manager.getProject()).reformat(qualifiedThis);
            PsiJavaCodeReferenceElement thisQualifier = qualifiedThis.getQualifier();
            LOG.assertTrue(thisQualifier != null);
            thisQualifier.bindToElement(qualifierClass);
            return (T)qualifiedThis;
        }
        return (T)((PsiQualifiedExpression)factory.createExpressionFromText(qName, null));
    }

    public static PsiThisExpression createThisExpression(PsiManager manager, PsiClass qualifierClass) throws IncorrectOperationException {
        return (PsiThisExpression)RefactoringChangeUtil.createQualifiedExpression(manager, qualifierClass, "this");
    }

    public static PsiSuperExpression createSuperExpression(PsiManager manager, PsiClass qualifierClass) throws IncorrectOperationException {
        return (PsiSuperExpression)RefactoringChangeUtil.createQualifiedExpression(manager, qualifierClass, "super");
    }
}

