/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNameValuePairPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotationPattern
extends PsiElementPattern<PsiAnnotation, PsiAnnotationPattern> {
    static final PsiAnnotationPattern PSI_ANNOTATION_PATTERN = new PsiAnnotationPattern();

    private PsiAnnotationPattern() {
        super(PsiAnnotation.class);
    }

    public PsiAnnotationPattern qName(final ElementPattern<String> pattern) {
        return (PsiAnnotationPattern)this.with(new PatternCondition<PsiAnnotation>("qName"){

            @Override
            public boolean accepts(@NotNull PsiAnnotation psiAnnotation, ProcessingContext context) {
                if (psiAnnotation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAnnotation", "com/intellij/patterns/PsiAnnotationPattern$1", "accepts"));
                }
                return pattern.accepts(psiAnnotation.getQualifiedName(), context);
            }
        });
    }

    public PsiAnnotationPattern qName(@NonNls String qname) {
        return this.qName((ElementPattern<String>)StandardPatterns.string().equalTo(qname));
    }

    public PsiAnnotationPattern insideAnnotationAttribute(final @NotNull String attributeName, final @NotNull ElementPattern<PsiAnnotation> parentAnnoPattern) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/patterns/PsiAnnotationPattern", "insideAnnotationAttribute"));
        }
        if (parentAnnoPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentAnnoPattern", "com/intellij/patterns/PsiAnnotationPattern", "insideAnnotationAttribute"));
        }
        return (PsiAnnotationPattern)this.with(new PatternCondition<PsiAnnotation>("insideAnnotationAttribute"){
            final PsiNameValuePairPattern attrPattern;
            {
                super(arg0);
                this.attrPattern = (PsiNameValuePairPattern)PsiJavaPatterns.psiNameValuePair().withName(attributeName).withSuperParent(2, parentAnnoPattern);
            }

            @Override
            public boolean accepts(@NotNull PsiAnnotation annotation, ProcessingContext context) {
                if (annotation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/patterns/PsiAnnotationPattern$2", "accepts"));
                }
                PsiElement attr = PsiAnnotationPattern.this.getParent(annotation);
                if (attr instanceof PsiArrayInitializerMemberValue) {
                    attr = PsiAnnotationPattern.this.getParent(attr);
                }
                return this.attrPattern.accepts(attr);
            }
        });
    }
}

