/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.SimpleTimerTask;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SimpleTimer {
    private static final SimpleTimer ourInstance = SimpleTimer.newInstance("Shared");
    private final ScheduledExecutorService myScheduledExecutorService;
    @NotNull
    private final String myName;

    private SimpleTimer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/SimpleTimer", "<init>"));
        }
        this.myScheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService("SimpleTimer pool", 1);
        this.myName = name;
    }

    public static SimpleTimer getInstance() {
        return ourInstance;
    }

    public static SimpleTimer newInstance(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/SimpleTimer", "newInstance"));
        }
        return new SimpleTimer(name);
    }

    @NotNull
    public SimpleTimerTask setUp(@NotNull Runnable runnable, long delay) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/SimpleTimer", "setUp"));
        }
        final ScheduledFuture<?> future = this.myScheduledExecutorService.schedule(runnable, delay, TimeUnit.MILLISECONDS);
        SimpleTimerTask simpleTimerTask = new SimpleTimerTask(){

            @Override
            public void cancel() {
                future.cancel(false);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }
        };
        if (simpleTimerTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SimpleTimer", "setUp"));
        }
        return simpleTimerTask;
    }

    public String toString() {
        return "SimpleTimer " + this.myName;
    }
}

