/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extension;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtensionPointImpl<T>
implements ExtensionPoint<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.extensions.impl.ExtensionPointImpl");
    private final AreaInstance myArea;
    private final String myName;
    private final String myClassName;
    private final ExtensionPoint.Kind myKind;
    private volatile T[] myExtensionsCache;
    private final ExtensionsAreaImpl myOwner;
    private final PluginDescriptor myDescriptor;
    private Set<ExtensionComponentAdapter> myExtensionAdapters;
    private final List<ExtensionPointListener<T>> myEPListeners;
    private List<ExtensionComponentAdapter> myLoadedAdapters;
    private Class<T> myExtensionClass;
    private static final StringInterner INTERNER = new StringInterner();
    private boolean processingAdaptersNow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtensionPointImpl(@NotNull String name, @NotNull String className, @NotNull ExtensionPoint.Kind kind, @NotNull ExtensionsAreaImpl owner, AreaInstance area, @NotNull PluginDescriptor descriptor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        this.myEPListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        StringInterner stringInterner = INTERNER;
        synchronized (stringInterner) {
            this.myName = INTERNER.intern(name);
        }
        this.myClassName = className;
        this.myKind = kind;
        this.myOwner = owner;
        this.myArea = area;
        this.myDescriptor = descriptor;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getName"));
        }
        return string;
    }

    @Override
    public AreaInstance getArea() {
        return this.myArea;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getClassName"));
        }
        return string;
    }

    @Override
    @NotNull
    public ExtensionPoint.Kind getKind() {
        ExtensionPoint.Kind kind = this.myKind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getKind"));
        }
        return kind;
    }

    @Override
    public void registerExtension(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        this.registerExtension(extension, LoadingOrder.ANY);
    }

    @NotNull
    public PluginDescriptor getDescriptor() {
        PluginDescriptor pluginDescriptor = this.myDescriptor;
        if (pluginDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getDescriptor"));
        }
        return pluginDescriptor;
    }

    @Override
    public synchronized void registerExtension(@NotNull T extension, @NotNull LoadingOrder order) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        if (order == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "order", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, order);
        if (LoadingOrder.ANY == order) {
            ExtensionComponentAdapter lastAdapter;
            int index;
            for (index = this.getLoadedAdaptersSize(); index > 0 && (lastAdapter = this.myLoadedAdapters.get(index - 1)).getOrder() == LoadingOrder.LAST; --index) {
            }
            this.registerExtension(extension, adapter, index, true);
        } else {
            this.registerExtensionAdapter(adapter);
            this.processAdapters();
        }
    }

    private int getLoadedAdaptersSize() {
        List<ExtensionComponentAdapter> loadedAdapters = this.myLoadedAdapters;
        return loadedAdapters == null ? 0 : loadedAdapters.size();
    }

    private void registerExtension(@NotNull T extension, @NotNull ExtensionComponentAdapter adapter, int index, boolean runNotifications) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        if (this.getExtensionIndex(extension) != -1) {
            this.myOwner.error("Extension was already added: " + extension);
            return;
        }
        Class<T> extensionClass = this.getExtensionClass();
        if (!extensionClass.isInstance(extension)) {
            this.myOwner.error("Extension " + extension.getClass() + " does not implement " + extensionClass);
            return;
        }
        if (this.myLoadedAdapters == null) {
            this.myLoadedAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        this.myLoadedAdapters.add(index, adapter);
        if (runNotifications) {
            this.clearCache();
            if (!adapter.isNotificationSent()) {
                if (extension instanceof Extension) {
                    try {
                        ((Extension)extension).extensionAdded(this);
                    }
                    catch (Throwable e) {
                        this.myOwner.error(e);
                    }
                }
                this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor());
                adapter.setNotificationSent(true);
            }
        }
    }

    private void notifyListenersOnAdd(@NotNull T extension, PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "notifyListenersOnAdd"));
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionAdded(extension, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myOwner.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T[] getExtensions() {
        Object[] result = this.myExtensionsCache;
        if (result == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result = this.myExtensionsCache;
                if (result == null) {
                    result = this.processAdapters();
                    if (result == null) {
                        result = (Object[])Array.newInstance(this.getExtensionClass(), 0);
                    }
                    this.myExtensionsCache = result;
                }
            }
        }
        Object[] objectArray = result.length == 0 ? result : (Object[])result.clone();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getExtensions"));
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyExtensions() {
        T[] cache = this.myExtensionsCache;
        if (cache != null) {
            return cache.length > 0;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            return this.getExtensionAdaptersSize() + this.getLoadedAdaptersSize() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means empty")
    private T[] processAdapters() {
        if (this.processingAdaptersNow) {
            throw new IllegalStateException("Recursive processAdapters() detected. You must have called 'getExtensions()' from within your extension constructor - don't. Either pass extension via constructor parameter or call getExtensions() later.");
        }
        int totalSize = this.getExtensionAdaptersSize() + this.getLoadedAdaptersSize();
        if (totalSize == 0) {
            return null;
        }
        this.processingAdaptersNow = true;
        try {
            Class<T> extensionClass = this.getExtensionClass();
            Object[] result = (Object[])Array.newInstance(extensionClass, totalSize);
            ArrayList adapters = ContainerUtil.newArrayListWithCapacity(totalSize);
            if (this.myExtensionAdapters != null) {
                adapters.addAll(this.myExtensionAdapters);
            }
            if (this.myLoadedAdapters != null) {
                adapters.addAll(this.myLoadedAdapters);
            }
            LoadingOrder.sort(adapters);
            this.myExtensionAdapters = new LinkedHashSet(adapters);
            Set<ExtensionComponentAdapter> loaded = ContainerUtil.newHashOrEmptySet(this.myLoadedAdapters);
            this.myLoadedAdapters = null;
            boolean errorHappened = false;
            for (int i = 0; i < adapters.size(); ++i) {
                ExtensionComponentAdapter adapter = (ExtensionComponentAdapter)adapters.get(i);
                try {
                    Object extension = adapter.getExtension();
                    if (extension == null) {
                        errorHappened = true;
                        LOG.error("null extension in: " + adapter + ";\ngetExtensionClass(): " + this.getExtensionClass() + ";\n");
                    }
                    if (i > 0 && extension == result[i - 1]) {
                        errorHappened = true;
                        LOG.error("Duplicate extension found: " + extension + ";  Adapter:      " + adapter + ";\n Prev adapter: " + adapters.get(i - 1) + ";\n getExtensionClass(): " + this.getExtensionClass() + ";\n result:" + Arrays.asList(result));
                    }
                    if (!extensionClass.isInstance(extension)) {
                        errorHappened = true;
                        this.myOwner.error("Extension " + (extension == null ? null : extension.getClass()) + " does not implement " + extensionClass + ". It came from " + adapter);
                        continue;
                    }
                    result[i] = extension;
                    this.registerExtension(extension, adapter, this.getLoadedAdaptersSize(), !loaded.contains(adapter));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    errorHappened = true;
                    LOG.error(e);
                }
                this.myExtensionAdapters.remove(adapter);
            }
            this.myExtensionAdapters = null;
            if (errorHappened) {
                result = ContainerUtil.findAllAsArray(result, Condition.NOT_NULL);
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.processingAdaptersNow = false;
        }
    }

    private int getExtensionAdaptersSize() {
        return this.myExtensionAdapters == null ? 0 : this.myExtensionAdapters.size();
    }

    public synchronized void removeUnloadableExtensions() {
        ExtensionComponentAdapter[] adapters;
        for (ExtensionComponentAdapter adapter : adapters = this.myExtensionAdapters == null ? ExtensionComponentAdapter.EMPTY_ARRAY : this.myExtensionAdapters.toArray(new ExtensionComponentAdapter[this.myExtensionAdapters.size()])) {
            try {
                adapter.getComponentImplementation();
            }
            catch (Throwable e) {
                this.unregisterExtensionAdapter(adapter);
            }
        }
    }

    @Override
    @Nullable
    public T getExtension() {
        T[] extensions = this.getExtensions();
        return extensions.length == 0 ? null : (T)extensions[0];
    }

    @Override
    public synchronized boolean hasExtension(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "hasExtension"));
        }
        T[] extensions = this.processAdapters();
        return extensions != null && ArrayUtil.contains(extension, extensions);
    }

    @Override
    public synchronized void unregisterExtension(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "unregisterExtension"));
        }
        int index = this.getExtensionIndex(extension);
        if (index == -1) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension);
        }
        ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(index);
        Object key = adapter.getComponentKey();
        this.myOwner.getPicoContainer().unregisterComponent(key);
        this.processAdapters();
        this.unregisterExtension(extension, null);
    }

    private int getExtensionIndex(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getExtensionIndex"));
        }
        if (this.myLoadedAdapters == null) {
            return -1;
        }
        for (int i = 0; i < this.myLoadedAdapters.size(); ++i) {
            ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(i);
            if (!Comparing.equal(adapter.getExtension(), extension)) continue;
            return i;
        }
        return -1;
    }

    private void unregisterExtension(@NotNull T extension, PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "unregisterExtension"));
        }
        int index = this.getExtensionIndex(extension);
        if (index == -1) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension);
        }
        this.myLoadedAdapters.remove(index);
        this.clearCache();
        this.notifyListenersOnRemove(extension, pluginDescriptor);
        if (extension instanceof Extension) {
            try {
                ((Extension)extension).extensionRemoved(this);
            }
            catch (Throwable e) {
                this.myOwner.error(e);
            }
        }
    }

    private void notifyListenersOnRemove(@NotNull T extensionObject, PluginDescriptor pluginDescriptor) {
        if (extensionObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionObject", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "notifyListenersOnRemove"));
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myOwner.error(e);
            }
        }
    }

    @Override
    public void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "addExtensionPointListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "addExtensionPointListener"));
        }
        this.addExtensionPointListener(listener, true, parentDisposable);
    }

    public synchronized void addExtensionPointListener(final @NotNull ExtensionPointListener<T> listener, final boolean invokeForLoadedExtensions, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "addExtensionPointListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "addExtensionPointListener"));
        }
        if (invokeForLoadedExtensions) {
            this.addExtensionPointListener(listener);
        } else {
            this.myEPListeners.add(listener);
        }
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ExtensionPointImpl.this.removeExtensionPointListener(listener, invokeForLoadedExtensions);
            }
        });
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "addExtensionPointListener"));
        }
        this.processAdapters();
        if (this.myEPListeners.add(listener)) {
            ExtensionComponentAdapter[] array;
            for (ExtensionComponentAdapter componentAdapter : array = this.myLoadedAdapters == null ? ExtensionComponentAdapter.EMPTY_ARRAY : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
                try {
                    Object extension = componentAdapter.getExtension();
                    listener.extensionAdded(extension, componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myOwner.error(e);
                }
            }
        }
    }

    @Override
    public void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "removeExtensionPointListener"));
        }
        this.removeExtensionPointListener(listener, true);
    }

    private synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "removeExtensionPointListener"));
        }
        if (this.myEPListeners.remove(listener) && invokeForLoadedExtensions) {
            ExtensionComponentAdapter[] array;
            for (ExtensionComponentAdapter componentAdapter : array = this.myLoadedAdapters == null ? ExtensionComponentAdapter.EMPTY_ARRAY : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
                try {
                    Object extension = componentAdapter.getExtension();
                    listener.extensionRemoved(extension, componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myOwner.error(e);
                }
            }
        }
    }

    @Override
    public synchronized void reset() {
        if (this.myExtensionAdapters != null) {
            this.myOwner.removeAllComponents(this.myExtensionAdapters);
            this.myExtensionAdapters = null;
        }
        for (T extension : this.getExtensions()) {
            this.unregisterExtension(extension);
        }
    }

    @Override
    @NotNull
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                Class<?> extClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getExtensionClass"));
        }
        return clazz;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void registerExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtensionAdapter"));
        }
        if (this.myExtensionAdapters == null) {
            this.myExtensionAdapters = new LinkedHashSet<ExtensionComponentAdapter>();
        }
        this.myExtensionAdapters.add(adapter);
        this.clearCache();
    }

    private void clearCache() {
        this.myExtensionsCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unregisterExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "unregisterExtensionAdapter"));
        }
        try {
            if (this.myExtensionAdapters != null && this.myExtensionAdapters.remove(adapter)) {
                boolean bl = true;
                return bl;
            }
            if (this.myLoadedAdapters != null && this.myLoadedAdapters.contains(adapter)) {
                Object key = adapter.getComponentKey();
                this.myOwner.getPicoContainer().unregisterComponent(key);
                Object extension = adapter.getExtension();
                this.unregisterExtension(extension, adapter.getPluginDescriptor());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    final synchronized void notifyAreaReplaced(ExtensionsArea area) {
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(area);
        }
    }

    private static class ObjectComponentAdapter
    extends ExtensionComponentAdapter {
        private final Object myExtension;
        private final LoadingOrder myLoadingOrder;

        private ObjectComponentAdapter(@NotNull Object extension, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter", "<init>"));
            }
            if (loadingOrder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadingOrder", "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter", "<init>"));
            }
            super(extension.getClass().getName(), null, null, null, false);
            this.myExtension = extension;
            this.myLoadingOrder = loadingOrder;
        }

        @Override
        public Object getExtension() {
            return this.myExtension;
        }

        @Override
        public LoadingOrder getOrder() {
            return this.myLoadingOrder;
        }

        @Override
        @Nullable
        public String getOrderId() {
            return null;
        }

        @Override
        @NonNls
        public Element getDescribingElement() {
            return new Element("RuntimeExtension: " + this.myExtension);
        }
    }
}

