/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.beans.PropertyChangeListener;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreEncodingProjectManager
extends EncodingProjectManager {
    @Override
    public boolean isNative2Ascii(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/core/CoreEncodingProjectManager", "isNative2Ascii"));
        }
        return false;
    }

    @Override
    @NotNull
    public Charset getDefaultCharset() {
        Charset charset = CharsetToolkit.getDefaultSystemCharset();
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreEncodingProjectManager", "getDefaultCharset"));
        }
        return charset;
    }

    @Override
    public Charset getEncoding(@Nullable VirtualFile virtualFile, boolean useParentDefaults) {
        return this.getDefaultCharset();
    }

    @Override
    public boolean isUseUTFGuessing(VirtualFile virtualFile) {
        return true;
    }

    @Override
    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
    }

    @Override
    public boolean isNative2AsciiForPropertiesFiles() {
        return false;
    }

    @Override
    @NotNull
    public Collection<Charset> getFavorites() {
        List<Charset> list = Collections.singletonList(CharsetToolkit.UTF8_CHARSET);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreEncodingProjectManager", "getFavorites"));
        }
        return list;
    }

    @Override
    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile, boolean native2Ascii) {
    }

    @Override
    @NotNull
    public String getDefaultCharsetName() {
        String string = this.getDefaultCharset().name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreEncodingProjectManager", "getDefaultCharsetName"));
        }
        return string;
    }

    @Override
    @Nullable
    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile) {
        return null;
    }

    @Override
    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile, @Nullable Charset charset) {
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/core/CoreEncodingProjectManager", "addPropertyChangeListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/core/CoreEncodingProjectManager", "addPropertyChangeListener"));
        }
    }

    @Override
    @Nullable
    public Charset getCachedCharsetFromContent(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/core/CoreEncodingProjectManager", "getCachedCharsetFromContent"));
        }
        return null;
    }

    @Override
    public void setDefaultCharsetName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreEncodingProjectManager", "setDefaultCharsetName"));
        }
    }
}

