/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformDocumentationUtil {
    @NonNls
    private static final Pattern ourLtFixupPattern = Pattern.compile("<(?=[^/!\\p{Alpha}])");
    @NonNls
    private static final String LT_ENTITY = "&lt;";

    @Nullable
    public static List<String> getHttpRoots(@NotNull String[] roots, String relPath) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/codeInsight/documentation/PlatformDocumentationUtil", "getHttpRoots"));
        }
        SmartList<String> result = new SmartList<String>();
        for (String root : roots) {
            String url;
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(root);
            if (virtualFile == null || (url = PlatformDocumentationUtil.getDocUrl(virtualFile, relPath)) == null) continue;
            result.add(url);
        }
        return result.isEmpty() ? null : result;
    }

    @Nullable
    public static String getDocUrl(@NotNull VirtualFile root, String relPath) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/documentation/PlatformDocumentationUtil", "getDocUrl"));
        }
        if (root.getFileSystem() instanceof HttpFileSystem) {
            String url = StringUtil.trimEnd(root.getUrl(), "/index.html", true);
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            return url + relPath;
        }
        VirtualFile file = root.findFileByRelativePath(relPath);
        return file == null ? null : file.getUrl();
    }

    public static String fixupText(@NotNull CharSequence docText) {
        if (docText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docText", "com/intellij/codeInsight/documentation/PlatformDocumentationUtil", "fixupText"));
        }
        return ourLtFixupPattern.matcher(docText).replaceAll(LT_ENTITY);
    }
}

