/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.SchemaModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class SchemaModuleUtil {
    private static final Map<String, JAXBContext> CONTEXT_CACHE = Maps.newHashMap();
    private static final Map<List<SchemaModule.SchemaModuleVersion<?>>, Map<LSResourceResolver, Schema>> SCHEMA_CACHE = Maps.newHashMap();

    public static LSResourceResolver createResourceResolver(Set<SchemaModule<?>> modules, ProgressIndicator progress) {
        return new SchemaModuleResourceResolver(modules, progress);
    }

    private static JAXBContext getContext(Collection<SchemaModule<?>> possibleModules) {
        JAXBContext jc;
        block5: {
            ArrayList packages = Lists.newArrayList();
            for (SchemaModule<?> module : possibleModules) {
                for (SchemaModule.SchemaModuleVersion version : module.getNamespaceVersionMap().values()) {
                    packages.add(version.getObjectFactory().getPackage().getName());
                }
            }
            String key = Joiner.on((String)":").join((Iterable)packages);
            jc = CONTEXT_CACHE.get(key);
            if (jc == null) {
                try {
                    jc = JAXBContext.newInstance((String)key, (ClassLoader)SchemaModuleUtil.class.getClassLoader());
                    CONTEXT_CACHE.put(key, jc);
                }
                catch (JAXBException e1) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)("Failed to create context!\n" + e1.toString()));
                }
            }
        }
        return jc;
    }

    @VisibleForTesting
    public static Schema getSchema(Collection<SchemaModule<?>> possibleModules, LSResourceResolver resourceResolver, final ProgressIndicator progress) {
        Schema schema;
        block7: {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (resourceResolver != null) {
                sf.setResourceResolver(resourceResolver);
            }
            sf.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    progress.logWarning("Warning while creating schema:", exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    progress.logWarning("Error creating schema:", exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    progress.logWarning("Fatal error creating schema:", exception);
                }
            });
            ArrayList sources = Lists.newArrayList();
            ArrayList key = Lists.newArrayList();
            for (SchemaModule<?> module : possibleModules) {
                for (SchemaModule.SchemaModuleVersion version : module.getNamespaceVersionMap().values()) {
                    key.add(version);
                    sources.add(new StreamSource(version.getXsd()));
                }
            }
            HashMap resolverSchemaCache = SCHEMA_CACHE.get(key);
            if (resolverSchemaCache == null) {
                resolverSchemaCache = Maps.newHashMap();
                SCHEMA_CACHE.put(key, resolverSchemaCache);
            }
            if ((schema = (Schema)resolverSchemaCache.get(resourceResolver)) == null) {
                try {
                    schema = sf.newSchema(sources.toArray(new StreamSource[sources.size()]));
                    resolverSchemaCache.put(resourceResolver, schema);
                }
                catch (SAXException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)"Invalid schema found!");
                }
            }
        }
        return schema;
    }

    public static Object unmarshal(InputStream xml, Collection<SchemaModule<?>> possibleModules, LSResourceResolver resourceResolver, boolean strict, ProgressIndicator progress) throws JAXBException {
        Unmarshaller u = SchemaModuleUtil.setupUnmarshaller(possibleModules, resourceResolver, strict, progress);
        SAXSource source = SchemaModuleUtil.setupSource(xml, possibleModules, strict, progress);
        return ((JAXBElement)u.unmarshal((Source)source)).getValue();
    }

    private static Unmarshaller setupUnmarshaller(Collection<SchemaModule<?>> possibleModules, LSResourceResolver resourceResolver, boolean strict, ProgressIndicator progress) throws JAXBException {
        JAXBContext context = SchemaModuleUtil.getContext(possibleModules);
        Schema schema = SchemaModuleUtil.getSchema(possibleModules, resourceResolver, progress);
        Unmarshaller u = context.createUnmarshaller();
        u.setSchema(schema);
        u.setEventHandler(SchemaModuleUtil.createValidationEventHandler(progress, strict));
        return u;
    }

    private static SAXSource setupSource(InputStream xml, Collection<SchemaModule<?>> possibleModules, boolean strict, ProgressIndicator progress) throws JAXBException {
        XMLReader xr;
        SAXSource source = new SAXSource(new InputSource(xml));
        NamespaceFallbackFilter filter = new NamespaceFallbackFilter(possibleModules, strict, progress);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        try {
            SAXParser sp = spf.newSAXParser();
            xr = sp.getXMLReader();
            xr.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException | SAXException e) {
            progress.logError("Error setting up parser", e);
            throw new JAXBException((Throwable)e);
        }
        filter.setParent(xr);
        source.setXMLReader(filter);
        return source;
    }

    public static void marshal(JAXBElement element, Collection<SchemaModule<?>> possibleModules, OutputStream out, LSResourceResolver resourceResolver, ProgressIndicator progress) {
        JAXBContext context = SchemaModuleUtil.getContext(possibleModules);
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setEventHandler(SchemaModuleUtil.createValidationEventHandler(progress, true));
            Schema schema = SchemaModuleUtil.getSchema(possibleModules, resourceResolver, progress);
            marshaller.setSchema(schema);
            marshaller.marshal((Object)element, out);
            out.close();
        }
        catch (IOException | JAXBException e) {
            progress.logWarning("Error during marshal", e);
        }
    }

    private static ValidationEventHandler createValidationEventHandler(ProgressIndicator progress, boolean strict) {
        return event -> {
            if (event.getLinkedException() != null) {
                progress.logWarning(event.getMessage(), event.getLinkedException());
            } else {
                progress.logWarning(event.getMessage());
            }
            return !strict;
        };
    }

    private static class NamespaceFallbackFilter
    extends XMLFilterImpl {
        private Map<String, SchemaModule<?>> mPrefixMap = Maps.newHashMap();
        private ProgressIndicator mProgress;
        private boolean mStrict;
        private Map<String, String> mNewToOldMap = Maps.newHashMap();

        public NamespaceFallbackFilter(Collection<SchemaModule<?>> possibleModules, boolean strict, ProgressIndicator progress) {
            for (SchemaModule<?> module : possibleModules) {
                this.mPrefixMap.put(module.getNamespacePrefix(), module);
            }
            this.mProgress = progress;
            this.mStrict = strict;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            int lastSlash;
            if (uri != null && (lastSlash = uri.lastIndexOf(47) + 1) > 0) {
                String namespacePrefix = uri.substring(0, lastSlash);
                try {
                    int version = Integer.parseInt(uri.substring(lastSlash));
                    SchemaModule<?> module = this.mPrefixMap.get(namespacePrefix);
                    if (module != null && module.getNamespaceVersionMap().size() < version) {
                        String oldUri = module.getLatestNamespace().intern();
                        this.mProgress.logWarning("Mapping new ns " + uri + " to old ns " + oldUri);
                        this.mNewToOldMap.put(uri, oldUri);
                        uri = oldUri;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            super.startPrefixMapping(prefix, uri);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            AttributesImpl newAtts = new AttributesImpl(atts);
            if (!this.mStrict && uri != null && this.mNewToOldMap.containsKey(uri)) {
                uri = this.mNewToOldMap.get(uri);
            }
            super.startElement(uri, localName, qName, newAtts);
        }
    }

    private static class SchemaModuleResourceResolver
    implements LSResourceResolver {
        private final Set<SchemaModule<?>> mModules;
        private static DOMImplementationLS sLs;

        public SchemaModuleResourceResolver(Set<SchemaModule<?>> modules, ProgressIndicator progress) {
            this.mModules = modules;
            SchemaModuleResourceResolver.initLs(progress);
        }

        private static void initLs(ProgressIndicator progress) {
            if (sLs == null) {
                try {
                    DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                    sLs = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                }
                catch (Exception e) {
                    progress.logError("Error during resolver creation: ", e);
                }
            }
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            for (SchemaModule<?> ext : this.mModules) {
                SchemaModule.SchemaModuleVersion version = ext.getNamespaceVersionMap().get(namespaceURI);
                if (version == null) continue;
                LSInput input = sLs.createLSInput();
                input.setSystemId(version.getNamespace());
                input.setByteStream(version.getXsd());
                return input;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SchemaModuleResourceResolver)) {
                return false;
            }
            SchemaModuleResourceResolver other = (SchemaModuleResourceResolver)obj;
            return other.mModules.equals(this.mModules);
        }

        public int hashCode() {
            return this.mModules.hashCode();
        }
    }
}

