/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import com.android.builder.model.Dependencies;
import com.android.builder.model.Variant;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastUtils;

public class DefaultJavaEvaluator
extends JavaEvaluator {
    private final com.intellij.openapi.project.Project myProject;
    private final Project myLintProject;

    public DefaultJavaEvaluator(com.intellij.openapi.project.Project project, Project lintProject) {
        this.myProject = project;
        this.myLintProject = lintProject;
    }

    @Override
    public Dependencies getDependencies() {
        Variant variant;
        if (this.myLintProject.isAndroidProject() && (variant = this.myLintProject.getCurrentVariant()) != null) {
            return variant.getMainArtifact().getDependencies();
        }
        return null;
    }

    @Override
    public boolean extendsClass(PsiClass cls, String className, boolean strict) {
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    public boolean implementsInterface(PsiClass cls, String interfaceName, boolean strict) {
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)interfaceName);
    }

    @Override
    public boolean inheritsFrom(PsiClass cls, String className, boolean strict) {
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    public PsiClass findClass(String qualifiedName) {
        return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)this.myProject).findClass(qualifiedName, GlobalSearchScope.allScope((com.intellij.openapi.project.Project)this.myProject));
    }

    @Override
    public PsiClassType getClassType(PsiClass cls) {
        return cls != null ? JavaPsiFacade.getElementFactory((com.intellij.openapi.project.Project)this.myProject).createType(cls) : null;
    }

    @Override
    public PsiAnnotation[] getAllAnnotations(PsiModifierListOwner owner, boolean inHierarchy) {
        return AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)inHierarchy, null, (boolean)false);
    }

    @Override
    public PsiAnnotation findAnnotationInHierarchy(PsiModifierListOwner listOwner, String ... annotationNames) {
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)listOwner, (Set)Sets.newHashSet((Object[])annotationNames));
    }

    @Override
    public PsiAnnotation findAnnotation(PsiModifierListOwner listOwner, String ... annotationNames) {
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (boolean)false, (String[])annotationNames);
    }

    @Override
    public boolean areSignaturesEqual(PsiMethod method1, PsiMethod method2) {
        return MethodSignatureUtil.areSignaturesEqual((PsiMethod)method1, (PsiMethod)method2);
    }

    @Override
    public String findJarPath(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        return DefaultJavaEvaluator.findJarPath(containingFile);
    }

    @Override
    public String findJarPath(UElement element) {
        UFile uFile = UastUtils.getContainingFile((UElement)element);
        return uFile != null ? DefaultJavaEvaluator.findJarPath(uFile.getPsi()) : null;
    }

    private static String findJarPath(PsiFile containingFile) {
        String path2;
        int separatorIndex;
        VirtualFile file;
        if (containingFile instanceof PsiCompiledFile && (file = containingFile.getVirtualFile()) != null && file.getFileSystem().getProtocol().equals("jar") && (separatorIndex = (path2 = file.getPath()).indexOf("!/")) >= 0) {
            return path2.substring(0, separatorIndex);
        }
        return null;
    }

    @Override
    public PsiPackage getPackage(PsiElement node) {
        PsiFile containingFile;
        PsiFile psiFile = containingFile = node instanceof PsiFile ? (PsiFile)node : node.getContainingFile();
        if (containingFile != null) {
            if (containingFile instanceof PsiJavaFile) {
                final String packageName = ((PsiJavaFile)containingFile).getPackageName();
                return new PsiPackageImpl(node.getManager(), packageName){

                    public PsiModifierList getAnnotationList() {
                        PsiClass cls = DefaultJavaEvaluator.this.findClass(packageName + '.' + "package-info");
                        if (cls != null) {
                            PsiModifierList modifierList = cls.getModifierList();
                            if (modifierList != null) {
                                return new PsiCompositeModifierList(this.getManager(), Collections.singletonList(modifierList));
                            }
                            return modifierList;
                        }
                        return null;
                    }
                };
            }
            PsiDirectory dir = containingFile.getParent();
            if (dir != null) {
                return JavaDirectoryService.getInstance().getPackage(dir);
            }
        }
        return null;
    }

    @Override
    public PsiPackage getPackage(UElement node) {
        UFile uFile = UastUtils.getContainingFile((UElement)node);
        if (uFile != null) {
            return this.getPackage((PsiElement)uFile.getPsi());
        }
        return null;
    }

    @Override
    public String getInternalName(PsiClassType psiClassType) {
        PsiType erased = TypeConversionUtil.erasure((PsiType)psiClassType);
        if (erased instanceof PsiClassType) {
            return super.getInternalName((PsiClassType)erased);
        }
        return super.getInternalName(psiClassType);
    }

    @Override
    public String getInternalName(PsiClass psiClass) {
        return LintUtils.getInternalName(psiClass);
    }

    @Override
    public String getInternalDescription(PsiMethod method, boolean includeName, boolean includeReturn) {
        assert (!includeName);
        assert (!includeReturn);
        StringBuilder signature = new StringBuilder();
        if (includeName) {
            if (method.isConstructor()) {
                PsiClass outerClass;
                PsiClass declaringClass = method.getContainingClass();
                if (declaringClass != null && (outerClass = declaringClass.getContainingClass()) != null && !declaringClass.hasModifierProperty("static") && !this.appendJvmTypeName(signature, outerClass)) {
                    return null;
                }
                signature.append("<init>");
            } else {
                signature.append(method.getName());
            }
        }
        signature.append('(');
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (this.appendJvmSignature(signature, psiParameter.getType())) continue;
            return null;
        }
        signature.append(')');
        if (includeReturn) {
            if (!method.isConstructor()) {
                if (!this.appendJvmSignature(signature, method.getReturnType())) {
                    return null;
                }
            } else {
                signature.append('V');
            }
        }
        return signature.toString();
    }

    private boolean appendJvmTypeName(StringBuilder signature, PsiClass outerClass) {
        String className = this.getInternalName(outerClass);
        if (className == null) {
            return false;
        }
        signature.append('L').append(className.replace('.', '/')).append(';');
        return true;
    }

    private boolean appendJvmSignature(StringBuilder buffer, PsiType type) {
        if (type == null) {
            return false;
        }
        PsiType psiType = TypeConversionUtil.erasure((PsiType)type);
        if (psiType instanceof PsiArrayType) {
            buffer.append('[');
            this.appendJvmSignature(buffer, ((PsiArrayType)psiType).getComponentType());
        } else if (psiType instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)psiType).resolve();
            if (resolved == null) {
                return false;
            }
            if (!this.appendJvmTypeName(buffer, resolved)) {
                return false;
            }
        } else if (psiType instanceof PsiPrimitiveType) {
            buffer.append(DefaultJavaEvaluator.getPrimitiveSignature(psiType.getCanonicalText()));
        } else {
            return false;
        }
        return true;
    }
}

