/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.InnerArchiveEntry;
import com.android.tools.apk.analyzer.internal.AndroidArtifact;
import com.android.tools.apk.analyzer.internal.ZipArtifact;
import com.android.utils.FileUtils;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.TreeTraverser;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.StreamSupport;

public class Archives {
    public static Archive open(Path archive) throws IOException {
        if (archive.getFileName().toString().toLowerCase().endsWith(".zip")) {
            return ZipArtifact.fromZippedBundle(archive);
        }
        FileSystem fileSystem = FileUtils.createZipFilesystem((Path)archive);
        return new AndroidArtifact(archive, fileSystem);
    }

    static Archive openInnerZip(Path archive) throws IOException {
        FileSystem fileSystem = FileUtils.createZipFilesystem((Path)archive);
        return new AndroidArtifact(archive, fileSystem);
    }

    public static Archive getFirstManifestArchive(ArchiveNode input) {
        FluentIterable bfsIterable = new TreeTraverser<ArchiveNode>(){

            public Iterable<ArchiveNode> children(ArchiveNode root) {
                return root.getChildren();
            }
        }.breadthFirstTraversal((Object)input);
        return StreamSupport.stream(bfsIterable.spliterator(), false).map(node -> node.getData() instanceof InnerArchiveEntry ? ((InnerArchiveEntry)node.getData()).asArchiveEntry().getArchive() : node.getData().getArchive()).distinct().filter(archive -> Files.exists(archive.getContentRoot().resolve("AndroidManifest.xml"), new LinkOption[0])).findFirst().orElse(null);
    }
}

