/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class BugReportImporter {
    private static final String TAG_HEADER = "------ EVENT LOG TAGS ------";
    private static final String LOG_HEADER = "------ EVENT LOG ------";
    private static final String HEADER_TAG = "------";
    private String[] mTags;
    private String[] mLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BugReportImporter(String filePath) throws FileNotFoundException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!TAG_HEADER.equals(line)) continue;
                this.readTags(reader);
                return;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String[] getTags() {
        return this.mTags;
    }

    public String[] getLog() {
        return this.mLog;
    }

    private void readTags(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> content = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if (LOG_HEADER.equals(line)) {
                this.mTags = content.toArray(new String[content.size()]);
                this.readLog(reader);
                return;
            }
            content.add(line);
        }
    }

    private void readLog(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> content = new ArrayList<String>();
        while ((line = reader.readLine()) != null && !line.startsWith(HEADER_TAG)) {
            content.add(line);
        }
        this.mLog = content.toArray(new String[content.size()]);
    }
}

