/*
 * Decompiled with CFR 0.152.
 */
package com.android.fakeadbserver.statechangehubs;

import com.android.fakeadbserver.statechangehubs.StateChangeHandlerFactory;
import com.android.fakeadbserver.statechangehubs.StateChangeQueue;
import java.util.HashMap;
import java.util.Map;

public abstract class StateChangeHub<FactoryType extends StateChangeHandlerFactory> {
    protected final Map<StateChangeQueue, FactoryType> mHandlers = new HashMap<StateChangeQueue, FactoryType>();
    protected volatile boolean mStopped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Map<StateChangeQueue, FactoryType> map = this.mHandlers;
        synchronized (map) {
            this.mStopped = true;
            this.mHandlers.forEach((stateChangeQueue, changeHandlerFactory) -> stateChangeQueue.add(() -> new StateChangeHandlerFactory.HandlerResult(false)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateChangeQueue subscribe(FactoryType handlerFactory) {
        Map<StateChangeQueue, FactoryType> map = this.mHandlers;
        synchronized (map) {
            if (this.mStopped) {
                return null;
            }
            StateChangeQueue queue = new StateChangeQueue();
            this.mHandlers.put(queue, handlerFactory);
            return queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(StateChangeQueue queue) {
        Map<StateChangeQueue, FactoryType> map = this.mHandlers;
        synchronized (map) {
            assert (this.mHandlers.containsKey(queue));
            this.mHandlers.remove(queue);
        }
    }
}

