/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state;

import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.StatePrettyPrinter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class GLListProperty
implements IGLProperty {
    private final List<IGLProperty> mList;
    private final GLStateType mType;
    private IGLProperty mParent;
    private IGLProperty mTemplate;

    public GLListProperty(GLStateType type, IGLProperty template, int size) {
        this.mType = type;
        this.mTemplate = template;
        this.mList = new ArrayList<IGLProperty>(size);
        int i = 0;
        while (i < size) {
            IGLProperty p = template.clone();
            this.mList.add(p);
            p.setParent(this);
            ++i;
        }
    }

    private GLListProperty(GLStateType type, List<IGLProperty> props) {
        this.mList = props;
        this.mType = type;
        for (IGLProperty p : this.mList) {
            p.setParent(this);
        }
    }

    public List<IGLProperty> getList() {
        return this.mList;
    }

    public IGLProperty get(int index) {
        return this.mList.get(index);
    }

    public boolean add(IGLProperty property) {
        property.setParent(this);
        return this.mList.add(property);
    }

    public boolean remove(IGLProperty property) {
        return this.mList.remove(property);
    }

    public void set(int index, IGLProperty property) {
        this.ensureCapacity(index + 1);
        this.mList.set(index, property);
        property.setParent(this);
    }

    private void ensureCapacity(int capactiy) {
        int i = this.mList.size();
        while (i < capactiy) {
            this.mList.add(this.mTemplate);
            ++i;
        }
    }

    @Override
    public GLListProperty clone() {
        ArrayList<IGLProperty> props = new ArrayList<IGLProperty>(this.mList.size());
        for (IGLProperty p : this.mList) {
            props.add(p.clone());
        }
        return new GLListProperty(this.getType(), props);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GLListProperty [");
        int i = 0;
        for (IGLProperty p : this.mList) {
            sb.append(i);
            sb.append(':');
            sb.append(p.toString());
            sb.append(", ");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getStringValue() {
        return "";
    }

    @Override
    public GLStateType getType() {
        return this.mType;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public IGLProperty getParent() {
        return this.mParent;
    }

    @Override
    public void setParent(IGLProperty parent) {
        this.mParent = parent;
    }

    public int indexOf(IGLProperty property) {
        return this.mList.indexOf(property);
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("Values cannot be set for composite properties.");
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("Values cannot be obtained for composite properties.");
    }

    public int size() {
        return this.mList.size();
    }

    @Override
    public void prettyPrint(StatePrettyPrinter pp) {
        pp.prettyPrint(this.mType, null);
        pp.incrementIndentLevel();
        int i = 0;
        while (i < this.mList.size()) {
            pp.prettyPrint(String.format(Locale.US, "Index %d:", i));
            IGLProperty p = this.mList.get(i);
            p.prettyPrint(pp);
            ++i;
        }
        pp.decrementIndentLevel();
    }
}

