/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.IGLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IStateTransform;
import java.nio.ByteBuffer;

public class BufferSubDataTransform
implements IStateTransform {
    private final IGLPropertyAccessor mAccessor;
    private final int mOffset;
    private final byte[] mSubData;
    private byte[] mOldData;
    private byte[] mNewData;

    public BufferSubDataTransform(IGLPropertyAccessor accessor, int offset, byte[] data) {
        this.mAccessor = accessor;
        this.mOffset = offset;
        this.mSubData = data;
    }

    @Override
    public void apply(IGLProperty state) {
        IGLProperty property = this.mAccessor.getProperty(state);
        this.mOldData = (byte[])property.getValue();
        if (this.mOldData != null) {
            this.mNewData = new byte[this.mOldData.length];
            ByteBuffer bb = ByteBuffer.wrap(this.mNewData);
            bb.put(this.mOldData);
            bb.rewind();
            bb.position(this.mOffset);
            bb.put(this.mSubData);
        }
        property.setValue(this.mNewData);
    }

    @Override
    public void revert(IGLProperty state) {
        if (this.mOldData != null) {
            IGLProperty property = this.mAccessor.getProperty(state);
            property.setValue(this.mOldData);
            this.mOldData = null;
        }
    }

    @Override
    public IGLProperty getChangedProperty(IGLProperty state) {
        return this.mAccessor.getProperty(state);
    }
}

