/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class PixelPerfectControls
extends Composite
implements PixelPerfectModel.IImageChangeListener {
    private Slider mOverlaySlider;
    private Slider mZoomSlider;
    private Slider mAutoRefreshSlider;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            PixelPerfectModel.getModel().removeImageChangeListener(PixelPerfectControls.this);
        }
    };
    private SelectionListener overlaySliderSelectionListener = new SelectionListener(){
        private int oldValue;

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            int newValue = PixelPerfectControls.this.mOverlaySlider.getSelection();
            if (this.oldValue != newValue) {
                PixelPerfectModel.getModel().removeImageChangeListener(PixelPerfectControls.this);
                PixelPerfectModel.getModel().setOverlayTransparency((double)newValue / 100.0);
                PixelPerfectModel.getModel().addImageChangeListener(PixelPerfectControls.this);
                this.oldValue = newValue;
            }
        }
    };
    private SelectionListener mRefreshSliderSelectionListener = new SelectionListener(){
        private int oldValue;

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            int newValue = PixelPerfectControls.this.mAutoRefreshSlider.getSelection();
            if (this.oldValue != newValue) {
                HierarchyViewerDirector.getDirector().setPixelPerfectAutoRefreshInterval(newValue);
            }
        }
    };
    private SelectionListener mZoomSliderSelectionListener = new SelectionListener(){
        private int oldValue;

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            int newValue = PixelPerfectControls.this.mZoomSlider.getSelection();
            if (this.oldValue != newValue) {
                PixelPerfectModel.getModel().removeImageChangeListener(PixelPerfectControls.this);
                PixelPerfectModel.getModel().setZoom(newValue);
                PixelPerfectModel.getModel().addImageChangeListener(PixelPerfectControls.this);
                this.oldValue = newValue;
            }
        }
    };

    public PixelPerfectControls(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FormLayout());
        Label overlayTransparencyRight = new Label((Composite)this, 0);
        overlayTransparencyRight.setText("100%");
        FormData overlayTransparencyRightData = new FormData();
        overlayTransparencyRightData.right = new FormAttachment(100, -2);
        overlayTransparencyRightData.top = new FormAttachment(0, 2);
        overlayTransparencyRight.setLayoutData((Object)overlayTransparencyRightData);
        Label refreshRight = new Label((Composite)this, 0);
        refreshRight.setText("40s");
        FormData refreshRightData = new FormData();
        refreshRightData.right = new FormAttachment(100, -2);
        refreshRightData.top = new FormAttachment((Control)overlayTransparencyRight, 2);
        refreshRightData.left = new FormAttachment((Control)overlayTransparencyRight, 0, 16384);
        refreshRight.setLayoutData((Object)refreshRightData);
        Label zoomRight = new Label((Composite)this, 0);
        zoomRight.setText("24x");
        FormData zoomRightData = new FormData();
        zoomRightData.right = new FormAttachment(100, -2);
        zoomRightData.top = new FormAttachment((Control)refreshRight, 2);
        zoomRightData.left = new FormAttachment((Control)overlayTransparencyRight, 0, 16384);
        zoomRight.setLayoutData((Object)zoomRightData);
        Label overlayTransparency = new Label((Composite)this, 0);
        Label refresh = new Label((Composite)this, 0);
        overlayTransparency.setText("Overlay:");
        FormData overlayTransparencyData = new FormData();
        overlayTransparencyData.left = new FormAttachment(0, 2);
        overlayTransparencyData.top = new FormAttachment(0, 2);
        overlayTransparencyData.right = new FormAttachment((Control)refresh, 0, 131072);
        overlayTransparency.setLayoutData((Object)overlayTransparencyData);
        refresh.setText("Refresh Rate:");
        FormData refreshData = new FormData();
        refreshData.top = new FormAttachment((Control)overlayTransparency, 2);
        refreshData.left = new FormAttachment(0, 2);
        refresh.setLayoutData((Object)refreshData);
        Label zoom = new Label((Composite)this, 0);
        zoom.setText("Zoom:");
        FormData zoomData = new FormData();
        zoomData.right = new FormAttachment((Control)refresh, 0, 131072);
        zoomData.top = new FormAttachment((Control)refresh, 2);
        zoomData.left = new FormAttachment(0, 2);
        zoom.setLayoutData((Object)zoomData);
        Label overlayTransparencyLeft = new Label((Composite)this, 131072);
        overlayTransparencyLeft.setText("0%");
        FormData overlayTransparencyLeftData = new FormData();
        overlayTransparencyLeftData.top = new FormAttachment(0, 2);
        overlayTransparencyLeftData.left = new FormAttachment((Control)overlayTransparency, 2);
        overlayTransparencyLeft.setLayoutData((Object)overlayTransparencyLeftData);
        Label refreshLeft = new Label((Composite)this, 131072);
        refreshLeft.setText("1s");
        FormData refreshLeftData = new FormData();
        refreshLeftData.top = new FormAttachment((Control)overlayTransparencyLeft, 2);
        refreshLeftData.left = new FormAttachment((Control)refresh, 2);
        refreshLeft.setLayoutData((Object)refreshLeftData);
        Label zoomLeft = new Label((Composite)this, 131072);
        zoomLeft.setText("2x");
        FormData zoomLeftData = new FormData();
        zoomLeftData.top = new FormAttachment((Control)refreshLeft, 2);
        zoomLeftData.left = new FormAttachment((Control)zoom, 2);
        zoomLeft.setLayoutData((Object)zoomLeftData);
        this.mOverlaySlider = new Slider((Composite)this, 256);
        this.mOverlaySlider.setMinimum(0);
        this.mOverlaySlider.setMaximum(101);
        this.mOverlaySlider.setThumb(1);
        this.mOverlaySlider.setSelection((int)Math.round(PixelPerfectModel.getModel().getOverlayTransparency() * 100.0));
        Image overlayImage = PixelPerfectModel.getModel().getOverlayImage();
        this.mOverlaySlider.setEnabled(overlayImage != null);
        FormData overlaySliderData = new FormData();
        overlaySliderData.right = new FormAttachment((Control)overlayTransparencyRight, -4);
        overlaySliderData.top = new FormAttachment(0, 2);
        overlaySliderData.left = new FormAttachment((Control)overlayTransparencyLeft, 4);
        this.mOverlaySlider.setLayoutData((Object)overlaySliderData);
        this.mOverlaySlider.addSelectionListener(this.overlaySliderSelectionListener);
        this.mAutoRefreshSlider = new Slider((Composite)this, 256);
        this.mAutoRefreshSlider.setMinimum(1);
        this.mAutoRefreshSlider.setMaximum(41);
        this.mAutoRefreshSlider.setThumb(1);
        this.mAutoRefreshSlider.setSelection(HierarchyViewerDirector.getDirector().getPixelPerfectAutoRefreshInverval());
        FormData refreshSliderData = new FormData();
        refreshSliderData.right = new FormAttachment((Control)overlayTransparencyRight, -4);
        refreshSliderData.top = new FormAttachment((Control)overlayTransparencyRight, 2);
        refreshSliderData.left = new FormAttachment((Control)this.mOverlaySlider, 0, 16384);
        this.mAutoRefreshSlider.setLayoutData((Object)refreshSliderData);
        this.mAutoRefreshSlider.addSelectionListener(this.mRefreshSliderSelectionListener);
        this.mZoomSlider = new Slider((Composite)this, 256);
        this.mZoomSlider.setMinimum(2);
        this.mZoomSlider.setMaximum(25);
        this.mZoomSlider.setThumb(1);
        this.mZoomSlider.setSelection(PixelPerfectModel.getModel().getZoom());
        FormData zoomSliderData = new FormData();
        zoomSliderData.right = new FormAttachment((Control)overlayTransparencyRight, -4);
        zoomSliderData.top = new FormAttachment((Control)refreshRight, 2);
        zoomSliderData.left = new FormAttachment((Control)this.mOverlaySlider, 0, 16384);
        this.mZoomSlider.setLayoutData((Object)zoomSliderData);
        this.mZoomSlider.addSelectionListener(this.mZoomSliderSelectionListener);
        this.addDisposeListener(this.mDisposeListener);
        PixelPerfectModel.getModel().addImageChangeListener(this);
    }

    @Override
    public void crosshairMoved() {
    }

    @Override
    public void treeChanged() {
    }

    @Override
    public void imageChanged() {
    }

    @Override
    public void imageLoaded() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Image overlayImage = PixelPerfectModel.getModel().getOverlayImage();
                PixelPerfectControls.this.mOverlaySlider.setEnabled(overlayImage != null);
                if (PixelPerfectModel.getModel().getImage() != null) {
                    PixelPerfectControls.this.mZoomSlider.setSelection(PixelPerfectModel.getModel().getZoom());
                }
            }
        });
    }

    @Override
    public void overlayChanged() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Image overlayImage = PixelPerfectModel.getModel().getOverlayImage();
                PixelPerfectControls.this.mOverlaySlider.setEnabled(overlayImage != null);
            }
        });
    }

    @Override
    public void overlayTransparencyChanged() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PixelPerfectControls.this.mOverlaySlider.setSelection((int)(PixelPerfectModel.getModel().getOverlayTransparency() * 100.0));
            }
        });
    }

    @Override
    public void selectionChanged() {
    }

    @Override
    public void zoomChanged() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PixelPerfectControls.this.mZoomSlider.setSelection(PixelPerfectModel.getModel().getZoom());
            }
        });
    }
}

