/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgLeafNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class SvgClipPathNode
extends SvgGroupNode {
    private static final Logger logger = Logger.getLogger(SvgLeafNode.class.getSimpleName());
    private static final String INDENT_LEVEL = "    ";
    private final ArrayList<SvgNode> mAffectedNodes = new ArrayList();

    public SvgClipPathNode(SvgTree svgTree, Node docNode, String name) {
        super(svgTree, docNode, name);
    }

    @Override
    public SvgClipPathNode deepCopy() {
        SvgClipPathNode newInstance = new SvgClipPathNode(this.getTree(), this.getDocumentNode(), this.getName());
        this.copyTo(newInstance);
        return newInstance;
    }

    protected void copyTo(SvgClipPathNode newInstance) {
        super.copyTo(newInstance);
        for (SvgNode n : this.mAffectedNodes) {
            newInstance.addAffectedNode(n);
        }
    }

    @Override
    public void addChild(SvgNode child) {
        this.mChildren.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    public void addAffectedNode(SvgNode child) {
        this.mAffectedNodes.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    @Override
    public void flatten(AffineTransform transform) {
        for (SvgNode n : this.mChildren) {
            this.mStackedTransform.setTransform(transform);
            this.mStackedTransform.concatenate(this.mLocalTransform);
            n.flatten(this.mStackedTransform);
        }
        this.mStackedTransform.setTransform(transform);
        this.mStackedTransform.concatenate(this.mLocalTransform);
        if (this.mVdAttributesMap.containsKey("stroke-width") && (this.mStackedTransform.getType() & 6) != 0) {
            this.getTree().logErrorLine("We don't scale the stroke width!", this.getDocumentNode(), SvgTree.SvgLogLevel.WARNING);
        }
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        for (SvgNode p : this.mChildren) {
            p.transformIfNeeded(rootTransform);
        }
    }

    @Override
    public void writeXML(OutputStreamWriter writer, boolean inClipPath) throws IOException {
        writer.write("    <group>\n");
        writer.write("        <clip-path android:pathData=\"");
        for (SvgNode node : this.mChildren) {
            node.writeXML(writer, true);
        }
        writer.write("\" />\n");
        for (SvgNode node : this.mAffectedNodes) {
            node.writeXML(writer, false);
        }
        writer.write("    </group>\n");
    }

    public void setClipPathNodeAttributes() {
        for (SvgNode n : this.mAffectedNodes) {
            this.mLocalTransform.concatenate(n.mLocalTransform);
        }
    }
}

