/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public class ResourceValueMap
extends ForwardingMap<String, ResourceValue> {
    private final Map<String, ResourceValue> myDelegate;
    private final Set<String> myKeys;

    private ResourceValueMap(Map<String, ResourceValue> delegate, Set<String> keySet) {
        this.myDelegate = delegate;
        this.myKeys = keySet;
    }

    public static ResourceValueMap createWithExpectedSize(int expectedSize) {
        return new ResourceValueMap(Maps.newHashMapWithExpectedSize((int)expectedSize), Sets.newHashSetWithExpectedSize((int)expectedSize));
    }

    public static ResourceValueMap create() {
        return new ResourceValueMap(Maps.newHashMap(), Sets.newHashSet());
    }

    @VisibleForTesting
    static String flattenKey(String key) {
        if (key == null) {
            return null;
        }
        int n = key.length();
        for (int i = 0; i < n; ++i) {
            char c = key.charAt(i);
            if (c != ':' && c != '.' && c != '-') continue;
            char[] buffer = new char[key.length()];
            key.getChars(0, i, buffer, 0);
            buffer[i] = 95;
            for (int j = i + 1; j < n; ++j) {
                c = key.charAt(j);
                buffer[j] = c == ':' || c == '.' || c == '-' ? 95 : (int)c;
            }
            return new String(buffer);
        }
        return key;
    }

    protected Map<String, ResourceValue> delegate() {
        return this.myDelegate;
    }

    public ResourceValue put(String key, ResourceValue value) {
        assert (key != null) : "ResourceValueMap does not support null keys";
        this.myKeys.add(key);
        return (ResourceValue)super.put((Object)ResourceValueMap.flattenKey(key), (Object)value);
    }

    public ResourceValue get(Object key) {
        assert (key != null) : "ResourceValueMap does not support null keys";
        return (ResourceValue)super.get((Object)ResourceValueMap.flattenKey((String)key));
    }

    public boolean containsKey(Object key) {
        assert (key != null) : "ResourceValueMap does not support null keys";
        return super.containsKey((Object)ResourceValueMap.flattenKey((String)key));
    }

    public ResourceValue remove(Object key) {
        assert (key != null) : "ResourceValueMap does not support null keys";
        this.myKeys.remove((String)key);
        return (ResourceValue)super.remove((Object)ResourceValueMap.flattenKey((String)key));
    }

    public Set<String> keySet() {
        return this.myKeys;
    }
}

