/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.CompileResourceRequest;
import com.android.ide.common.res2.ResourceCompiler;
import com.android.utils.FileUtils;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public interface QueueableResourceCompiler
extends ResourceCompiler,
Closeable {
    public static final QueueableResourceCompiler NONE = new QueueableResourceCompiler(){

        @Override
        public void close() throws IOException {
        }

        public ListenableFuture<File> compile(CompileResourceRequest request) throws Exception {
            File out = this.compileOutputFor(request);
            FileUtils.copyFile((File)request.getInput(), (File)out);
            return Futures.immediateFuture((Object)out);
        }

        @Override
        public File compileOutputFor(CompileResourceRequest request) {
            File parentDir = new File(request.getOutput(), request.getFolderName());
            FileUtils.mkdirs((File)parentDir);
            return new File(parentDir, request.getInput().getName());
        }
    };

    public File compileOutputFor(CompileResourceRequest var1);
}

