/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal.wizard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.AbstractPage;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.StyledErrorDialog;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.model.ProfileElement;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class ExportPage
extends AbstractPage {
    static /* synthetic */ Class class$0;

    public ExportPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.ExportPage_Title);
        this.setDescription(Messages.ExportPage_Description);
    }

    protected void createContents(Composite composite) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 2, true, false));
        if (this.getSelfProfile() == null) {
            label.setText(Messages.ExportPage_ERROR_CONFIG);
        } else {
            label.setText(Messages.ExportPage_Label);
            this.createInstallationTable(composite);
            this.createDestinationGroup(composite);
        }
    }

    public void doFinish() throws Exception {
        this.finishException = null;
        if (this.viewer == null) {
            return;
        }
        this.saveWidgetValues();
        final Object[] checked = this.viewer.getCheckedElements();
        OutputStream stream = null;
        try {
            File target = new File(this.destinationNameField.getText());
            if (!target.exists()) {
                target.createNewFile();
            }
            final OutputStream out = stream = new BufferedOutputStream(new FileOutputStream(target));
            this.getContainer().run(true, true, new IRunnableWithProgress(){
                boolean tryAgain = false;

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    try {
                        IInstallableUnit[] units = new IInstallableUnit[checked.length];
                        int i = 0;
                        while (i < units.length) {
                            Object object = checked[i];
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            units[i] = (IInstallableUnit)ProvUI.getAdapter((Object)object, (Class)clazz);
                            ++i;
                        }
                        IStatus status = ExportPage.this.importexportService.exportP2F(out, units, monitor);
                        if (status.isMultiStatus()) {
                            final StringBuilder sb = new StringBuilder();
                            IStatus[] iStatusArray = status.getChildren();
                            int n = iStatusArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IStatus child = iStatusArray[n2];
                                if (child.isMultiStatus()) {
                                    IStatus[] iStatusArray2 = child.getChildren();
                                    int n3 = iStatusArray2.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        IStatus grandchild = iStatusArray2[n4];
                                        sb.append("<li>").append(grandchild.getMessage()).append("</li>");
                                        ++n4;
                                    }
                                } else if (child.isOK()) {
                                    sb.insert(0, Messages.ExportPage_SuccessWithProblems);
                                } else {
                                    sb.insert(0, Messages.ExportPage_Fail);
                                    sb.append(status.getMessage());
                                }
                                ++n2;
                            }
                            sb.append(Messages.ExportPage_FixSuggestion);
                            sb.append(Messages.ExportPage_TryAgainQuestion);
                            Runnable runnable = new Runnable(){

                                public void run() {
                                    String title = Messages.ExportPage_Title;
                                    tryAgain = StyledErrorDialog.openQuestion(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, sb.toString());
                                }
                            };
                            Display.getDefault().syncExec(runnable);
                            if (this.tryAgain) {
                                throw new OperationCanceledException("User chosed try again.");
                            }
                        }
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.finishException != null) {
                throw this.finishException;
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.finishException != null) {
            throw this.finishException;
        }
    }

    protected String getDialogTitle() {
        return Messages.ExportPage_FILEDIALOG_TITLE;
    }

    protected Object getInput() {
        ProfileElement element = new ProfileElement(null, this.getSelfProfile().getProfileId());
        return element;
    }

    protected String getInvalidDestinationMessage() {
        return Messages.ExportPage_DEST_ERRORMESSAGE;
    }

    protected void giveFocusToDestination() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        }
    }

    protected String getDestinationLabel() {
        return Messages.ExportPage_LABEL_EXPORTFILE;
    }

    protected int getBrowseDialogStyle() {
        return 8192;
    }
}

