/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintSyntaxHighlighter;
import com.android.tools.lint.Main;
import com.android.tools.lint.MultiProjectHtmlReporter;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Beta
public class MaterialHtmlReporter
extends Reporter {
    private static final int SPLIT_LIMIT;
    private static final int SHOWN_COUNT;
    static final int CODE_WINDOW_SIZE;
    private static final String REPORT_PREFERENCE_PROPERTY = "lint.html.prefs";
    private static final boolean USE_WAVY_UNDERLINES_FOR_ERRORS;
    private static final boolean USE_CSS_DECORATION_FOR_WAVY_UNDERLINES = false;
    private static String preferredThemeName;
    private static final String CSS_SYNTAX_COLORS_LIGHT_THEME;
    private static final String CSS_SYNTAX_COLORS_DARCULA;
    private static final String CSS_SYNTAX_COLORS_SOLARIZED;
    private static final String CSS_SYNTAX_COLORS;
    static final String CSS_STYLES;
    protected final Writer writer;
    protected final LintCliFlags flags;
    private HtmlBuilder builder;
    private StringBuilder sb;
    private String highlightedFile;
    private LintSyntaxHighlighter highlighter;
    int cardNumber = 0;
    final Set<String> usedCardIds = Sets.newHashSet();
    static final Comparator<File> ICON_DENSITY_COMPARATOR;

    public MaterialHtmlReporter(LintCliClient client, File output, LintCliFlags flags) throws IOException {
        super(client, output);
        this.writer = new BufferedWriter(Files.newWriter((File)output, (Charset)Charsets.UTF_8));
        this.flags = flags;
    }

    @Override
    public void write(Reporter.Stats stats, List<Warning> issues) throws IOException {
        Map<Issue, String> missing = this.computeMissingIssues(issues);
        List<List<Warning>> related = MaterialHtmlReporter.computeIssueLists(issues);
        this.startReport(stats);
        this.writeNavigationHeader(stats, () -> {
            this.append("      <a class=\"mdl-navigation__link\" href=\"#overview\"><i class=\"material-icons\">dashboard</i>Overview</a>\n");
            for (List warnings : related) {
                Warning first = (Warning)warnings.get(0);
                String anchor = first.issue.getId();
                String desc = first.issue.getBriefDescription(TextFormat.HTML);
                this.append("      <a class=\"mdl-navigation__link\" href=\"#" + anchor + "\">");
                if (first.severity.isError()) {
                    this.append("<i class=\"material-icons error-icon\">error</i>");
                } else {
                    this.append("<i class=\"material-icons warning-icon\">warning</i>");
                }
                this.append(desc + " (" + warnings.size() + ")</a>\n");
            }
        });
        if (!issues.isEmpty()) {
            this.append("\n<a name=\"overview\"></a>\n");
            this.writeCard(() -> this.writeOverview(related, missing.size()), "Overview", true, "OverviewCard", new Action[0]);
            Category previousCategory = null;
            for (List<Warning> warnings : related) {
                Category category = warnings.get((int)0).issue.getCategory();
                if (category != previousCategory) {
                    previousCategory = category;
                    this.append("\n<a name=\"");
                    this.append(category.getFullName());
                    this.append("\"></a>\n");
                }
                this.writeIssueCard(warnings);
            }
            if (!this.client.isCheckingSpecificIssues()) {
                this.writeMissingIssues(missing);
            }
            this.writeSuppressIssuesCard();
        } else {
            this.writeCard(() -> this.append("Congratulations!"), "No Issues Found", "NoIssuesCard");
        }
        this.finishReport();
        this.writeReport();
        if (!(this.client.getFlags().isQuiet() || stats.errorCount <= 0 && stats.warningCount <= 0)) {
            String url = SdkUtils.fileToUrlString((File)this.output.getAbsoluteFile());
            System.out.println(String.format("Wrote HTML report to %1$s", url));
        }
    }

    private void append(String s) {
        this.sb.append(s);
    }

    private void append(char s) {
        this.sb.append(s);
    }

    private void writeSuppressIssuesCard() {
        this.append("\n<a name=\"SuppressInfo\"></a>\n");
        this.writeCard(() -> {
            this.append(TextFormat.RAW.convertTo(Main.getSuppressHelp(), TextFormat.HTML));
            this.append('\n');
        }, "Suppressing Warnings and Errors", "SuppressCard");
    }

    private void writeIssueCard(List<Warning> warnings) {
        Issue firstIssue = warnings.get((int)0).issue;
        this.append("<a name=\"" + firstIssue.getId() + "\"></a>\n");
        this.writeCard(() -> {
            Warning first = (Warning)warnings.get(0);
            Issue issue = first.issue;
            this.append("<div class=\"issue\">\n");
            this.append("<div class=\"warningslist\">\n");
            boolean partialHide = !this.simpleFormat && warnings.size() > SPLIT_LIMIT;
            int count = 0;
            for (Warning warning : warnings) {
                if (count >= 50) {
                    if (count == 50) {
                        this.append("<br/><b>NOTE: " + Integer.toString(warnings.size() - count) + " results omitted.</b><br/><br/>");
                    }
                    ++count;
                    continue;
                }
                if (partialHide && count == SHOWN_COUNT) {
                    String id = warning.issue.getId() + "Div";
                    this.append("<button");
                    this.append(" class=\"mdl-button mdl-js-button mdl-button--primary\"");
                    this.append(" id=\"");
                    this.append(id);
                    this.append("Link\" onclick=\"reveal('");
                    this.append(id);
                    this.append("');\" />");
                    this.append(String.format("+ %1$d More Occurrences...", warnings.size() - SHOWN_COUNT));
                    this.append("</button>\n");
                    this.append("<div id=\"");
                    this.append(id);
                    this.append("\" style=\"display: none\">\n");
                }
                ++count;
                String url = null;
                if (warning.path != null) {
                    url = this.writeLocation(warning.file, warning.path, warning.line);
                    this.append(':');
                    this.append(' ');
                }
                boolean addedImage = false;
                if (url != null && warning.location != null && warning.location.getSecondary() == null) {
                    addedImage = this.addImage(url, warning.file, warning.location);
                }
                String rawMessage = warning.message;
                if (issue == IssueRegistry.LINT_ERROR && rawMessage.contains("\u2190")) {
                    rawMessage = rawMessage.replace("\u2190", "\n\u2190");
                }
                this.append("<span class=\"message\">");
                this.append(TextFormat.RAW.convertTo(rawMessage, TextFormat.HTML));
                this.append("</span>");
                if (addedImage) {
                    this.append("<br clear=\"right\"/>");
                } else {
                    this.append("<br />");
                }
                if (warning.line >= 0 && warning.fileContents != null) {
                    this.appendCodeBlock(warning.file, warning.fileContents, warning.offset, warning.endOffset, warning.severity);
                }
                this.append('\n');
                if (warning.location != null && warning.location.getSecondary() != null) {
                    String path;
                    int line;
                    Position start;
                    Location l;
                    this.append("<ul>");
                    int otherLocations = 0;
                    int shownSnippetsCount = 0;
                    for (l = warning.location.getSecondary(); l != null; l = l.getSecondary()) {
                        String message = l.getMessage();
                        if (message != null && !message.isEmpty()) {
                            start = l.getStart();
                            line = start != null ? start.getLine() : -1;
                            path = this.client.getDisplayPath(warning.project, l.getFile());
                            this.writeLocation(l.getFile(), path, line);
                            this.append(':');
                            this.append(' ');
                            this.append("<span class=\"message\">");
                            this.append(TextFormat.RAW.convertTo(message, TextFormat.HTML));
                            this.append("</span>");
                            this.append("<br />");
                            if (shownSnippetsCount >= 3 || LintUtils.isBitmapFile((File)l.getFile())) continue;
                            CharSequence s = this.client.readFile(l.getFile());
                            if (s.length() > 0) {
                                int offset = start != null ? start.getOffset() : -1;
                                this.appendCodeBlock(l.getFile(), s, offset, -1, warning.severity);
                            }
                            ++shownSnippetsCount;
                            continue;
                        }
                        ++otherLocations;
                    }
                    this.append("</ul>");
                    if (otherLocations > 0) {
                        String id = "Location" + count + "Div";
                        this.append("<button id=\"");
                        this.append(id);
                        this.append("Link\" onclick=\"reveal('");
                        this.append(id);
                        this.append("');\" />");
                        this.append(String.format("+ %1$d Additional Locations...", otherLocations));
                        this.append("</button>\n");
                        this.append("<div id=\"");
                        this.append(id);
                        this.append("\" style=\"display: none\">\n");
                        this.append("Additional locations: ");
                        this.append("<ul>\n");
                        for (l = warning.location.getSecondary(); l != null; l = l.getSecondary()) {
                            start = l.getStart();
                            line = start != null ? start.getLine() : -1;
                            path = this.client.getDisplayPath(warning.project, l.getFile());
                            this.append("<li> ");
                            this.writeLocation(l.getFile(), path, line);
                            this.append("\n");
                        }
                        this.append("</ul>\n");
                        this.append("</div><br/><br/>\n");
                    }
                }
                if (!addedImage && url != null && warning.location != null && warning.location.getSecondary() != null) {
                    this.addImage(url, warning.file, warning.location);
                }
                if (!warning.isVariantSpecific()) continue;
                this.append("\n");
                this.append("Applies to variants: ");
                this.append(Joiner.on((String)", ").join(warning.getIncludedVariantNames()));
                this.append("<br/>\n");
                this.append("Does <b>not</b> apply to variants: ");
                this.append(Joiner.on((String)", ").join(warning.getExcludedVariantNames()));
                this.append("<br/>\n");
            }
            if (partialHide) {
                this.append("</div>\n");
            }
            this.append("</div>\n");
            this.writeIssueMetadata(issue, null, true);
            this.append("</div>\n");
            this.append("<div class=\"chips\">\n");
            this.writeChip(issue.getId());
            for (Category category = issue.getCategory(); category != null && category != Category.LINT; category = category.getParent()) {
                this.writeChip(category.getName());
            }
            this.writeChip(first.severity.getDescription());
            this.writeChip("Priority " + issue.getPriority() + "/10");
            this.append("</div>\n");
        }, XmlUtils.toXmlTextValue((String)firstIssue.getBriefDescription(TextFormat.TEXT)), true, firstIssue.getId() + "Card", new Action("Explain", MaterialHtmlReporter.getExplanationId(firstIssue), "reveal"));
    }

    private static List<List<Warning>> computeIssueLists(List<Warning> issues) {
        Issue previousIssue = null;
        ArrayList<List<Warning>> related = new ArrayList<List<Warning>>();
        if (!issues.isEmpty()) {
            ArrayList<Warning> currentList = null;
            for (Warning warning : issues) {
                if (warning.issue != previousIssue) {
                    previousIssue = warning.issue;
                    currentList = new ArrayList<Warning>();
                    related.add(currentList);
                }
                assert (currentList != null);
                currentList.add(warning);
            }
        }
        return related;
    }

    private void startReport(Reporter.Stats stats) {
        this.sb = new StringBuilder(1800 * stats.count());
        this.builder = new HtmlBuilder(this.sb);
        this.writeOpenHtmlTag();
        this.writeHeadTag();
        this.writeOpenBodyTag();
    }

    private void finishReport() {
        this.writeCloseNavigationHeader();
        this.writeCloseBodyTag();
        this.writeCloseHtmlTag();
    }

    private void writeNavigationHeader(Reporter.Stats stats, Runnable appender) {
        this.append("<div class=\"mdl-layout mdl-js-layout mdl-layout--fixed-header\">\n  <header class=\"mdl-layout__header\">\n    <div class=\"mdl-layout__header-row\">\n      <span class=\"mdl-layout-title\">" + this.title + ": " + LintUtils.describeCounts((int)stats.errorCount, (int)stats.warningCount, (boolean)false, (boolean)true) + "</span>\n" + "      <div class=\"mdl-layout-spacer\"></div>\n" + "      <nav class=\"mdl-navigation mdl-layout--large-screen-only\">\n");
        this.append(String.format("Check performed at %1$s", new Date().toString()));
        this.append("      </nav>\n    </div>\n  </header>\n  <div class=\"mdl-layout__drawer\">\n    <span class=\"mdl-layout-title\">Issue Types</span>\n    <nav class=\"mdl-navigation\">\n");
        appender.run();
        this.append("    </nav>\n  </div>\n  <main class=\"mdl-layout__content\">\n    <div class=\"mdl-layout__tab-panel is-active\">");
    }

    private void writeCloseNavigationHeader() {
        this.append("    </div>\n  </main>\n</div>");
    }

    private void writeOpenBodyTag() {
        this.append("<body class=\"mdl-color--grey-100 mdl-color-text--grey-700 mdl-base\">\n");
    }

    private void writeCloseBodyTag() {
        this.append("\n</body>\n");
    }

    private void writeOpenHtmlTag() {
        this.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
    }

    private void writeCloseHtmlTag() {
        this.append("</html>");
    }

    private void writeHeadTag() {
        this.append("\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n<title>" + this.title + "</title>\n");
        this.append("<link rel=\"stylesheet\" href=\"https://fonts.googleapis.com/icon?family=Material+Icons\">\n <link rel=\"stylesheet\" href=\"https://code.getmdl.io/1.2.1/material.blue-indigo.min.css\" />\n<link rel=\"stylesheet\" href=\"http://fonts.googleapis.com/css?family=Roboto:300,400,500,700\" type=\"text/css\">\n<script defer src=\"https://code.getmdl.io/1.2.0/material.min.js\"></script>\n");
        this.append("<style>\n" + CSS_STYLES + "</style>\n");
        this.append("<script language=\"javascript\" type=\"text/javascript\"> \n<!--\nfunction reveal(id) {\nif (document.getElementById) {\ndocument.getElementById(id).style.display = 'block';\ndocument.getElementById(id+'Link').style.display = 'none';\n}\n}\nfunction hideid(id) {\nif (document.getElementById) {\ndocument.getElementById(id).style.display = 'none';\n}\n}\n//--> \n</script>\n");
        this.append("</head>\n");
    }

    private void writeIssueMetadata(Issue issue, String disabledBy, boolean hide) {
        this.append("<div class=\"metadata\">");
        if (disabledBy != null) {
            this.append(String.format("Disabled By: %1$s<br/>\n", disabledBy));
        }
        this.append("<div class=\"explanation\"");
        if (hide) {
            this.append(" id=\"" + MaterialHtmlReporter.getExplanationId(issue) + "\" style=\"display: none;\"");
        }
        this.append(">\n");
        String explanationHtml = issue.getExplanation(TextFormat.HTML);
        this.append(explanationHtml);
        List moreInfo = issue.getMoreInfo();
        this.append("<br/>");
        int count = moreInfo.size();
        if (count > 0) {
            this.append("<div class=\"moreinfo\">");
            this.append("More info: ");
            if (count > 1) {
                this.append("<ul>");
            }
            for (String uri : moreInfo) {
                if (count > 1) {
                    this.append("<li>");
                }
                this.append("<a href=\"");
                this.append(uri);
                this.append("\">");
                this.append(uri);
                this.append("</a>\n");
            }
            if (count > 1) {
                this.append("</ul>");
            }
            this.append("</div>");
        }
        if (this.client.getRegistry() instanceof BuiltinIssueRegistry && Reporter.hasAutoFix(issue)) {
            this.append("Note: This issue has an associated quickfix operation in Android Studio and IntelliJ IDEA.");
            this.append("<br>\n");
        }
        this.append(String.format("To suppress this error, use the issue id \"%1$s\" as explained in the %2$sSuppressing Warnings and Errors%3$s section.", issue.getId(), "<a href=\"#SuppressInfo\">", "</a>"));
        this.append("<br/>\n");
        this.append("<br/>");
        this.append("</div>");
        this.append("\n</div>\n");
    }

    protected Map<Issue, String> computeMissingIssues(List<Warning> warnings) {
        HashSet<Project> projects = new HashSet<Project>();
        HashSet<Issue> seen = new HashSet<Issue>();
        for (Warning warning : warnings) {
            projects.add(warning.project);
            seen.add(warning.issue);
        }
        Configuration cliConfiguration = this.client.getConfiguration();
        HashMap map = Maps.newHashMap();
        block1: for (Issue issue : this.client.getRegistry().getIssues()) {
            if (seen.contains(issue)) continue;
            if (this.client.isSuppressed(issue)) {
                map.put(issue, "Command line flag");
                continue;
            }
            if (!issue.isEnabledByDefault() && !this.client.isAllEnabled()) {
                map.put(issue, "Default");
                continue;
            }
            if (cliConfiguration != null && !cliConfiguration.isEnabled(issue)) {
                map.put(issue, "Command line supplied --config lint.xml file");
                continue;
            }
            for (Project project : projects) {
                if (project.getConfiguration(null).isEnabled(issue)) continue;
                map.put(issue, "Project lint.xml file");
                continue block1;
            }
        }
        return map;
    }

    private void writeMissingIssues(Map<Issue, String> missing) {
        if (!this.client.isCheckingSpecificIssues()) {
            this.append("\n<a name=\"MissingIssues\"></a>\n");
            this.writeCard(() -> {
                this.append("One or more issues were not run by lint, either \nbecause the check is not enabled by default, or because \nit was disabled with a command line flag or via one or \nmore <code>lint.xml</code> configuration files in the project directories.\n");
                this.append("<div id=\"SuppressedIssues\" style=\"display: none;\">");
                ArrayList list = new ArrayList(missing.keySet());
                Collections.sort(list);
                this.append("<br/><br/>");
                for (Issue issue : list) {
                    this.append("<div class=\"issue\">\n");
                    this.append("<div class=\"id\">");
                    this.append(issue.getId());
                    this.append("<div class=\"issueSeparator\"></div>\n");
                    this.append("</div>\n");
                    String disabledBy = (String)missing.get(issue);
                    this.writeIssueMetadata(issue, disabledBy, false);
                    this.append("</div>\n");
                }
                this.append("</div>");
            }, "Disabled Checks", true, "MissingIssuesCard", new Action("List Missing Issues", "SuppressedIssues", "reveal"));
        }
    }

    private void writeOverview(List<List<Warning>> related, int missingCount) {
        this.append("<table class=\"overview\">\n");
        Category previousCategory = null;
        for (List<Warning> warnings : related) {
            Warning first = warnings.get(0);
            Issue issue = first.issue;
            boolean isError = first.severity.isError();
            if (issue.getCategory() != previousCategory) {
                this.append("<tr><td class=\"countColumn\"></td><td class=\"categoryColumn\">");
                previousCategory = issue.getCategory();
                String categoryName = issue.getCategory().getFullName();
                this.append("<a href=\"#");
                this.append(categoryName);
                this.append("\">");
                this.append(categoryName);
                this.append("</a>\n");
                this.append("</td></tr>");
                this.append("\n");
            }
            this.append("<tr>\n");
            this.append("<td class=\"countColumn\">");
            this.append(Integer.toString(warnings.size()));
            this.append("</td>");
            this.append("<td class=\"issueColumn\">");
            if (isError) {
                this.append("<i class=\"material-icons error-icon\">error</i>");
            } else {
                this.append("<i class=\"material-icons warning-icon\">warning</i>");
            }
            this.append('\n');
            this.append("<a href=\"#");
            this.append(issue.getId());
            this.append("\">");
            this.append(issue.getId());
            this.append("</a>");
            this.append(": ");
            this.append(issue.getBriefDescription(TextFormat.HTML));
            this.append("</td></tr>\n");
        }
        if (missingCount > 0 && !this.client.isCheckingSpecificIssues()) {
            this.append("<tr><td></td>");
            this.append("<td class=\"categoryColumn\">");
            this.append("<a href=\"#MissingIssues\">");
            this.append(String.format("Disabled Checks (%1$d)", missingCount));
            this.append("</a>\n");
            this.append("</td></tr>");
        }
        this.append("</table>\n");
        this.append("<br/>");
    }

    private static String getCardId(int cardNumber) {
        return "card" + cardNumber;
    }

    private static String getExplanationId(Issue issue) {
        return "explanation" + issue.getId();
    }

    public void writeCardHeader(String title, String cardId) {
        this.append("<section class=\"section--center mdl-grid mdl-grid--no-spacing mdl-shadow--2dp\" id=\"" + cardId + "\" style=\"display: block;\">\n" + "            <div class=\"mdl-card mdl-cell mdl-cell--12-col\">\n");
        if (title != null) {
            this.append("  <div class=\"mdl-card__title\">\n    <h2 class=\"mdl-card__title-text\">" + title + "</h2>\n" + "  </div>\n");
        }
        this.append("              <div class=\"mdl-card__supporting-text\">\n");
    }

    public void writeCardAction(Action ... actions) {
        this.append("              </div>\n              <div class=\"mdl-card__actions mdl-card--border\">\n");
        for (Action action : actions) {
            this.append("<button class=\"mdl-button mdl-js-button mdl-js-ripple-effect\" id=\"" + action.id + "Link\"" + " onclick=\"" + action.function + "('" + action.id + "');" + "\">\n" + action.title + "</button>");
        }
    }

    public void writeCardFooter() {
        this.append("            </div>\n            </div>\n          </section>");
    }

    public void writeCard(Runnable appender, String title, String cardId) {
        this.writeCard(appender, title, false, cardId, new Action[0]);
    }

    public void writeChip(String text) {
        this.append("<span class=\"mdl-chip\">\n    <span class=\"mdl-chip__text\">" + text + "</span>\n" + "</span>\n");
    }

    public void writeCard(Runnable appender, String title, boolean dismissible, String cardId, Action ... actions) {
        if (cardId == null) {
            int card = this.cardNumber++;
            cardId = MaterialHtmlReporter.getCardId(card);
        }
        assert (!this.usedCardIds.contains(cardId)) : cardId;
        this.usedCardIds.add(cardId);
        this.writeCardHeader(title, cardId);
        appender.run();
        if (dismissible) {
            String dismissTitle = "Dismiss";
            if ("New Lint Report Format".equals(title)) {
                dismissTitle = "Got It";
            }
            actions = (Action[])ObjectArrays.concat((Object[])actions, (Object)new Action(dismissTitle, cardId, "hideid"));
            this.writeCardAction(actions);
        }
        this.writeCardFooter();
    }

    private String writeLocation(File file, String path, int line) {
        this.append("<span class=\"location\">");
        String url = this.getUrl(file);
        if (url != null) {
            this.append("<a href=\"");
            this.append(url);
            this.append("\">");
        }
        String displayPath = this.stripPath(path);
        if (url != null && url.startsWith("../") && new File(displayPath).isAbsolute()) {
            displayPath = url;
        }
        this.append(displayPath);
        if (url != null) {
            this.append("</a>");
        }
        if (line >= 0) {
            this.append(':');
            this.append(Integer.toString(line + 1));
        }
        this.append("</span>");
        return url;
    }

    private static int getDensity(File file) {
        Density density;
        DensityQualifier qualifier;
        String name;
        FolderConfiguration configuration;
        File parent = file.getParentFile();
        if (parent != null && (configuration = FolderConfiguration.getConfigForFolder((String)(name = parent.getName()))) != null && (qualifier = configuration.getDensityQualifier()) != null && !qualifier.hasFakeValue() && (density = qualifier.getValue()) != null) {
            return density.getDpiValue();
        }
        return 0;
    }

    private boolean addImage(String url, File urlFile, Location location) {
        if (url != null && urlFile != null && LintUtils.isBitmapFile((File)urlFile)) {
            if (location.getSecondary() != null) {
                ArrayList files = Lists.newArrayList();
                while (location != null) {
                    File file = location.getFile();
                    if (LintUtils.isBitmapFile((File)file)) {
                        files.add(file);
                    }
                    location = location.getSecondary();
                }
                files.sort(ICON_DENSITY_COMPARATOR);
                ArrayList<String> urls = new ArrayList<String>();
                for (File file : files) {
                    String imageUrl = this.getUrl(file);
                    if (imageUrl == null) continue;
                    urls.add(imageUrl);
                }
                if (!urls.isEmpty()) {
                    this.append("<table>\n");
                    this.append("<tr>");
                    for (String linkedUrl : urls) {
                        this.append("<td>");
                        this.append("<a href=\"");
                        this.append(linkedUrl);
                        this.append("\">");
                        this.append("<img border=\"0\" align=\"top\" src=\"");
                        this.append(linkedUrl);
                        this.append("\" /></a>\n");
                        this.append("</td>");
                    }
                    this.append("</tr>");
                    this.append("<tr>");
                    for (String linkedUrl : urls) {
                        int end;
                        this.append("<th>");
                        int index = linkedUrl.lastIndexOf("drawable-");
                        if (index != -1 && (end = linkedUrl.indexOf(47, index += "drawable-".length())) != -1) {
                            this.append(linkedUrl.substring(index, end));
                        }
                        this.append("</th>");
                    }
                    this.append("</tr>\n");
                    this.append("</table>\n");
                }
            } else {
                this.append("<img class=\"embedimage\" align=\"right\" src=\"");
                this.append(url);
                this.append("\" />");
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeProjectList(Reporter.Stats stats, List<MultiProjectHtmlReporter.ProjectEntry> projects) throws IOException {
        this.startReport(stats);
        this.writeNavigationHeader(stats, () -> {
            for (MultiProjectHtmlReporter.ProjectEntry entry : projects) {
                this.append("      <a class=\"mdl-navigation__link\" href=\"" + XmlUtils.toXmlAttributeValue((String)entry.fileName) + "\">" + entry.path + " (" + (entry.errorCount + entry.warningCount) + ")</a>\n");
            }
        });
        if (stats.errorCount == 0 && stats.warningCount == 0) {
            this.writeCard(() -> this.append("Congratulations!"), "No Issues Found", "NoIssuesCard");
            return;
        }
        this.writeCard(() -> {
            this.append("<table class=\"overview\">\n");
            this.append("<tr><th>");
            this.append("Project");
            this.append("</th><th class=\"countColumn\">");
            this.append("Errors");
            this.append("</th><th class=\"countColumn\">");
            this.append("Warnings");
            this.append("</th></tr>\n");
            for (MultiProjectHtmlReporter.ProjectEntry entry : projects) {
                this.append("<tr><td>");
                this.append("<a href=\"");
                this.append(XmlUtils.toXmlAttributeValue((String)entry.fileName));
                this.append("\">");
                this.append(entry.path);
                this.append("</a></td><td class=\"countColumn\">");
                this.append(Integer.toString(entry.errorCount));
                this.append("</td><td class=\"countColumn\">");
                this.append(Integer.toString(entry.warningCount));
                this.append("</td></tr>\n");
                this.append("<tr>\n");
            }
            this.append("</table>\n");
            this.append("<br/>");
        }, "Projects", "OverviewCard");
        this.finishReport();
        this.writeReport();
    }

    private void writeReport() throws IOException {
        this.writer.write(this.sb.toString());
        this.writer.close();
        this.sb = null;
        this.builder = null;
    }

    private LintSyntaxHighlighter getHighlighter(File file, CharSequence contents) {
        if (this.highlightedFile == null || !this.highlightedFile.equals(file.getPath())) {
            this.highlighter = new LintSyntaxHighlighter(file.getName(), contents.toString());
            this.highlighter.setPadCaretLine(true);
            this.highlighter.setDedent(true);
            this.highlightedFile = file.getPath();
        }
        return this.highlighter;
    }

    private void appendCodeBlock(File file, CharSequence contents, int startOffset, int endOffset, Severity severity) {
        this.getHighlighter(file, contents).generateHtml(this.builder, startOffset, endOffset, severity.isError());
    }

    static {
        String css;
        preferredThemeName = "light";
        String preferences = System.getProperty(REPORT_PREFERENCE_PROPERTY);
        int codeWindowSize = 3;
        int splitLimit = 8;
        boolean underlineErrors = true;
        if (preferences != null) {
            for (String pref : Splitter.on((char)',').omitEmptyStrings().split((CharSequence)preferences)) {
                int index = pref.indexOf(61);
                if (index == -1) continue;
                String key = pref.substring(0, index).trim();
                String value = pref.substring(index + 1).trim();
                if ("theme".equals(key)) {
                    preferredThemeName = value;
                    continue;
                }
                if ("window".equals(key)) {
                    try {
                        int size = Integer.decode(value);
                        if (size < 1 || size >= 3000) continue;
                        codeWindowSize = size;
                    }
                    catch (NumberFormatException size) {}
                    continue;
                }
                if ("maxPerIssue".equals(key)) {
                    try {
                        int count = Integer.decode(value);
                        if (count < 1 || count >= 3000) continue;
                        splitLimit = count;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (!"underlineErrors".equals(key)) continue;
                underlineErrors = Boolean.valueOf(value);
            }
        }
        SPLIT_LIMIT = splitLimit;
        SHOWN_COUNT = Math.max(1, SPLIT_LIMIT - 3);
        CODE_WINDOW_SIZE = codeWindowSize;
        USE_WAVY_UNDERLINES_FOR_ERRORS = underlineErrors;
        CSS_SYNTAX_COLORS_LIGHT_THEME = "pre.errorlines {\n    background-color: white;\n    font-family: monospace;\n    border: 1px solid #e0e0e0;\n    line-height: 0.9rem;\n    font-size: 0.9rem;    padding: 1px 0px 1px; 1px;\n    overflow: scroll;\n}\n.prefix {\n    color: #660e7a;\n    font-weight: bold;\n}\n.attribute {\n    color: #0000ff;\n    font-weight: bold;\n}\n.value {\n    color: #008000;\n    font-weight: bold;\n}\n.tag {\n    color: #000080;\n    font-weight: bold;\n}\n.comment {\n    color: #808080;\n    font-style: italic;\n}\n.javadoc {\n    color: #808080;\n    font-style: italic;\n}\n.annotation {\n    color: #808000;\n}\n.string {\n    color: #008000;\n    font-weight: bold;\n}\n.number {\n    color: #0000ff;\n}\n.keyword {\n    color: #000080;\n    font-weight: bold;\n}\n.caretline {\n    background-color: #fffae3;\n}\n.lineno {\n    color: #999999;\n    background-color: #f0f0f0;\n}\n.error {\n" + (USE_WAVY_UNDERLINES_FOR_ERRORS ? "    display: inline-block;\n    position:relative;\n    background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAAECAYAAACp8Z5+AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4AwCFR4T/3uLMgAAADxJREFUCNdNyLERQEAABMCjL4lQwIzcjErpguAL+C9AvgKJDbeD/PRpLdm35Hm+MU+cB+tCKaJW4L4YBy+CAiLJrFs9mgAAAABJRU5ErkJggg==) bottom repeat-x;\n" : "    text-decoration: none;\n    background-color: #f8d8d8;\n") + "}\n" + ".warning {\n" + "    text-decoration: none;\n" + "    background-color: #f6ebbc;\n" + "}\n";
        CSS_SYNTAX_COLORS_DARCULA = "pre.errorlines {\n    background-color: #2b2b2b;\n    color: #a9b7c6;\n    font-family: monospace;\n    font-size: 0.9rem;    line-height: 0.9rem;\n    padding: 6px;\n    border: 1px solid #e0e0e0;\n    overflow: scroll;\n}\n.prefix {\n    color: #9876aa;\n}\n.attribute {\n    color: #BABABA;\n}\n.value {\n    color: #6a8759;\n}\n.tag {\n    color: #e8bf6a;\n}\n.comment {\n    color: #808080;\n}\n.javadoc {\n    font-style: italic;\n    color: #629755;\n}\n.annotation {\n    color: #BBB529;\n}\n.string {\n    color: #6a8759;\n}\n.number {\n    color: #6897bb;\n}\n.keyword {\n    color: #cc7832;\n}\n.caretline {\n    background-color: #323232;\n}\n.lineno {\n    color: #606366;\n    background-color: #313335;\n}\n.error {\n" + (USE_WAVY_UNDERLINES_FOR_ERRORS ? "    display: inline-block;\n    position:relative;\n    background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAAECAYAAACp8Z5+AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4AwCFR46vckTXgAAAEBJREFUCNdj1NbW/s+ABJj4mJgYork5GNgZGSECYVzsDKd+/WaI5uZgEGVmYmBZ9e0nw6d//xg+/vvJEM7FwQAAPnUOmQBDSmAAAAAASUVORK5CYII=) bottom repeat-x;\n" : "    text-decoration: none;\n    background-color: #52503a;\n") + "}\n" + ".warning {\n" + "    text-decoration: none;\n" + "    background-color: #52503a;\n" + "}\n";
        CSS_SYNTAX_COLORS_SOLARIZED = "pre.errorlines {\n    background-color: #FDF6E3;\n    color: #586E75;\n    font-family: monospace;\n    font-size: 0.9rem;    line-height: 0.9rem;\n    padding: 0px;\n    border: 1px solid #e0e0e0;\n    overflow: scroll;\n}\n.prefix {\n    color: #6C71C4;\n}\n.attribute {\n}\n.value {\n    color: #2AA198;\n}\n.tag {\n    color: #268BD2;\n}\n.comment {\n    color: #DC322F;\n}\n.javadoc {\n    font-style: italic;\n    color: #859900;\n}\n.annotation {\n    color: #859900;\n}\n.string {\n    color: #2AA198;\n}\n.number {\n    color: #CB4B16;\n}\n.keyword {\n    color: #B58900;\n}\n.caretline {\n    background-color: #EEE8D5;\n}\n.lineno {\n    color: #93A1A1;\n    background-color: #EEE8D5;\n}\n.error {\n" + (USE_WAVY_UNDERLINES_FOR_ERRORS ? "    display: inline-block;\n    position:relative;\n    background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAADCAYAAAC09K7GAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4AwCFRgHs/v4yQAAAD5JREFUCNcBMwDM/wDqe2//++zZ//324v/75NH/AgxKRgDuho8A/OTnAO2KkwAA/fbi//nXxf/mZlz/++TR/4EMI0ZH4MfyAAAAAElFTkSuQmCC) bottom repeat-x;\n" : "    text-decoration: none;\n    color: #073642;\n    background-color: #FFA0A3;\n") + "}\n" + ".warning {\n" + "    text-decoration: none;\n" + "    color: #073642;\n" + "    background-color: #FFDF80;\n" + "}\n";
        switch (preferredThemeName) {
            case "darcula": {
                css = CSS_SYNTAX_COLORS_DARCULA;
                break;
            }
            case "solarized": {
                css = CSS_SYNTAX_COLORS_SOLARIZED;
                break;
            }
            default: {
                css = CSS_SYNTAX_COLORS_LIGHT_THEME;
            }
        }
        CSS_SYNTAX_COLORS = css;
        CSS_STYLES = "section.section--center {\n    max-width: 860px;\n}\n.mdl-card__supporting-text + .mdl-card__actions {\n    border-top: 1px solid rgba(0, 0, 0, 0.12);\n}\nmain > .mdl-layout__tab-panel {\n  padding: 8px;\n  padding-top: 48px;\n}\n\n.mdl-card__actions {\n    margin: 0;\n    padding: 4px 40px;\n    color: inherit;\n}\n.mdl-card > * {\n    height: auto;\n}\n.mdl-card__actions a {\n    color: #00BCD4;\n    margin: 0;\n}\n.error-icon {\n    color: #bb7777;\n    vertical-align: bottom;\n}\n.warning-icon {\n    vertical-align: bottom;\n}\n.mdl-layout__content section:not(:last-of-type) {\n  position: relative;\n  margin-bottom: 48px;\n}\n\n.mdl-card .mdl-card__supporting-text {\n  margin: 40px;\n  -webkit-flex-grow: 1;\n      -ms-flex-positive: 1;\n          flex-grow: 1;\n  padding: 0;\n  color: inherit;\n  width: calc(100% - 80px);\n}\ndiv.mdl-layout__drawer-button .material-icons {\n    line-height: 48px;\n}\n.mdl-card .mdl-card__supporting-text {\n    margin-top: 0px;\n}\n.chips {\n    float: right;\n    vertical-align: middle;\n}\n" + CSS_SYNTAX_COLORS + ".overview {\n" + "    padding: 10pt;\n" + "    width: 100%;\n" + "    overflow: auto;\n" + "    border-collapse:collapse;\n" + "}\n" + ".overview tr {\n" + "    border-bottom: solid 1px #eeeeee;\n" + "}\n" + ".categoryColumn a {\n" + "     text-decoration: none;\n" + "     color: inherit;\n" + "}\n" + ".countColumn {\n" + "    text-align: right;\n" + "    padding-right: 20px;\n" + "    width: 50px;\n" + "}\n" + ".issueColumn {\n" + "   padding-left: 16px;\n" + "}\n" + ".categoryColumn {\n" + "   position: relative;\n" + "   left: -50px;\n" + "   padding-top: 20px;\n" + "   padding-bottom: 5px;\n" + "}\n";
        ICON_DENSITY_COMPARATOR = (file1, file2) -> {
            int density2;
            int density1 = MaterialHtmlReporter.getDensity(file1);
            int densityDelta = density1 - (density2 = MaterialHtmlReporter.getDensity(file2));
            if (densityDelta != 0) {
                return densityDelta;
            }
            return file1.getName().compareToIgnoreCase(file2.getName());
        };
    }

    private static class Action {
        public final String title;
        public final String id;
        public final String function;

        public Action(String title, String id, String function) {
            this.title = title;
            this.id = id;
            this.function = function;
        }
    }
}

