/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScrollViewChildDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"ScrollViewSize", (String)"ScrollView size validation", (String)"ScrollView children must set their `layout_width` or `layout_height` attributes to `wrap_content` rather than `fill_parent` or `match_parent` in the scrolling dimension", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.WARNING, (Implementation)new Implementation(ScrollViewChildDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public Collection<String> getApplicableElements() {
        return Arrays.asList("ScrollView", "HorizontalScrollView");
    }

    public void visitElement(XmlContext context, Element element) {
        boolean isHorizontal = "HorizontalScrollView".equals(element.getTagName());
        String attributeName = isHorizontal ? "layout_width" : "layout_height";
        for (Element child : XmlUtils.getSubTags((Node)element)) {
            Attr sizeNode = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
            if (sizeNode == null) {
                return;
            }
            String value = sizeNode.getValue();
            if (!"fill_parent".equals(value) && !"match_parent".equals(value)) continue;
            String msg = String.format("This %1$s should use `android:%2$s=\"wrap_content\"`", child.getTagName(), attributeName);
            context.report(ISSUE, (Node)sizeNode, context.getLocation((Node)sizeNode), msg);
        }
    }
}

