/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.checks.RangeConstraint;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UExpression;

class IntRangeConstraint
extends RangeConstraint {
    final long from;
    final long to;

    public static IntRangeConstraint create(PsiAnnotation annotation) {
        assert ("android.support.annotation.IntRange".equals(annotation.getQualifiedName()));
        PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("from");
        PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("to");
        long from = IntRangeConstraint.getLongValue((PsiElement)fromValue, Long.MIN_VALUE);
        long to = IntRangeConstraint.getLongValue((PsiElement)toValue, Long.MAX_VALUE);
        return new IntRangeConstraint(from, to);
    }

    public static IntRangeConstraint create(UAnnotation annotation) {
        assert ("android.support.annotation.IntRange".equals(annotation.getQualifiedName()));
        long from = PermissionRequirement.getAnnotationLongValue(annotation, "from", Long.MIN_VALUE);
        long to = PermissionRequirement.getAnnotationLongValue(annotation, "to", Long.MAX_VALUE);
        return new IntRangeConstraint(from, to);
    }

    static IntRangeConstraint atLeast(long value) {
        return new IntRangeConstraint(value, Long.MAX_VALUE);
    }

    static IntRangeConstraint atMost(long value) {
        return new IntRangeConstraint(Long.MIN_VALUE, value);
    }

    static IntRangeConstraint range(long from, long to) {
        return new IntRangeConstraint(from, to);
    }

    private IntRangeConstraint(long from, long to) {
        this.from = from;
        this.to = to;
    }

    public boolean isValid(long value) {
        return value >= this.from && value <= this.to;
    }

    @Override
    public Boolean isValid(UExpression argument) {
        Number literalValue = this.guessSize(argument);
        if (literalValue != null) {
            long value = literalValue.longValue();
            return value >= this.from && value <= this.to;
        }
        return null;
    }

    public String describe() {
        return this.describe(null);
    }

    @Override
    public String describe(UExpression argument) {
        return this.describe(argument, null);
    }

    public String describe(long argument) {
        return this.describe(null, argument);
    }

    private String describe(UExpression argument, Long actualValue) {
        Number actual;
        StringBuilder sb = new StringBuilder(20);
        if (actualValue != null && !this.isValid(actualValue)) {
            long value = actualValue;
            if (value < this.from) {
                sb.append("Value must be \u2265 ");
                sb.append(Long.toString(this.from));
            } else {
                assert (value > this.to);
                sb.append("Value must be \u2264 ");
                sb.append(Long.toString(this.to));
            }
            sb.append(" (was ").append(value).append(')');
            return sb.toString();
        }
        if (this.to == Long.MAX_VALUE) {
            sb.append("Value must be \u2265 ");
            sb.append(Long.toString(this.from));
        } else if (this.from == Long.MIN_VALUE) {
            sb.append("Value must be \u2264 ");
            sb.append(Long.toString(this.to));
        } else {
            sb.append("Value must be \u2265 ");
            sb.append(Long.toString(this.from));
            sb.append(" and \u2264 ");
            sb.append(Long.toString(this.to));
        }
        if (actualValue != null) {
            sb.append(" (is ").append(actualValue).append(')');
        } else if (argument != null && (actual = this.guessSize(argument)) != null) {
            sb.append(" (is ").append(Integer.toString(actual.intValue())).append(')');
        }
        return sb.toString();
    }

    public String toString() {
        return this.describe(null);
    }

    @Override
    public Boolean contains(RangeConstraint other) {
        if (other instanceof IntRangeConstraint) {
            IntRangeConstraint otherRange = (IntRangeConstraint)other;
            return otherRange.from >= this.from && otherRange.to <= this.to;
        }
        if (other instanceof FloatRangeConstraint) {
            FloatRangeConstraint otherRange = (FloatRangeConstraint)other;
            if (!otherRange.fromInclusive && otherRange.from == (double)this.from || !otherRange.toInclusive && otherRange.to == (double)this.to) {
                return false;
            }
            if (otherRange.to > (double)this.to && (!Double.isInfinite(otherRange.to) || this.to != Long.MAX_VALUE)) {
                return false;
            }
            if (otherRange.from < (double)this.from && (!Double.isInfinite(otherRange.from) || this.from != Long.MIN_VALUE)) {
                return false;
            }
            return true;
        }
        return null;
    }
}

