/*
 * Decompiled with CFR 0.152.
 */
package com.doyensec.ajp13;

import com.doyensec.ajp13.AbstractAjpMessage;
import com.doyensec.ajp13.AjpReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class BodyMessage
extends AbstractAjpMessage {
    final int length;
    final byte[] bytes;

    public BodyMessage(byte[] bytes) throws IOException {
        super(0);
        this.length = bytes.length;
        this.bytes = bytes;
        if (this.length != 0) {
            this.writeInt(this.length);
            this.writeBytes(bytes);
        }
    }

    static BodyMessage readFrom(InputStream in) throws IOException {
        int length = AjpReader.readInt(in);
        byte[] bytes = AjpReader.readBytes(length, in);
        return new BodyMessage(bytes);
    }

    public String toString() {
        try {
            return new String(this.bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("[!] SendBodyChunkMessage UnsupportedEncodingException: " + ex.getLocalizedMessage());
            return "InvalidEncoding";
        }
    }

    public byte[] getBody() {
        return this.bytes;
    }

    @Override
    public String getName() {
        return "Body Data Message";
    }

    @Override
    public String getDescription() {
        return "Remaining request body data.\nContent (HEX):\n0x" + AjpReader.getHex(this.bytes) + "\nContent (Ascii):\n" + this.toString();
    }
}

