/*
 * Decompiled with CFR 0.152.
 */
package asg.cliche.util;

import asg.cliche.util.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayHashMultiMap<K, V>
implements MultiMap<K, V> {
    private Map<K, List<V>> listMap = new HashMap<K, List<V>>();

    public ArrayHashMultiMap() {
    }

    public ArrayHashMultiMap(MultiMap<K, V> map) {
        this();
        this.putAll(map);
    }

    @Override
    public void put(K key, V value) {
        List<V> values = this.listMap.get(key);
        if (values == null) {
            values = new ArrayList<V>();
            this.listMap.put(key, values);
        }
        values.add(value);
    }

    @Override
    public Collection<V> get(K key) {
        List<V> result = this.listMap.get(key);
        if (result == null) {
            result = new ArrayList<V>();
        }
        return result;
    }

    @Override
    public Set<K> keySet() {
        return this.listMap.keySet();
    }

    @Override
    public void remove(K key, V value) {
        List<V> values = this.listMap.get(key);
        if (values != null) {
            values.remove(value);
            if (values.isEmpty()) {
                this.listMap.remove(key);
            }
        }
    }

    @Override
    public void removeAll(K key) {
        this.listMap.remove(key);
    }

    @Override
    public int size() {
        int sum = 0;
        for (K key : this.listMap.keySet()) {
            sum += this.listMap.get(key).size();
        }
        return sum;
    }

    @Override
    public void putAll(MultiMap<K, V> map) {
        for (K key : map.keySet()) {
            for (V val : map.get(key)) {
                this.put(key, val);
            }
        }
    }

    public String toString() {
        return this.listMap.toString();
    }
}

