/*
 * Decompiled with CFR 0.152.
 */
package asg.cliche.example;

import asg.cliche.Command;
import asg.cliche.InputConverter;
import asg.cliche.OutputConverter;
import asg.cliche.Shell;
import asg.cliche.ShellDependent;
import asg.cliche.ShellFactory;
import asg.cliche.example.HelloWorld;
import java.io.IOException;
import java.util.ArrayList;

public class Example
implements ShellDependent {
    public static final InputConverter[] CLI_INPUT_CONVERTERS = new InputConverter[]{new InputConverter(){

        public Integer convertInput(String original, Class toClass) throws Exception {
            if (toClass.equals(Integer.class)) {
                if (original.equals("one")) {
                    return 1;
                }
                if (original.equals("two")) {
                    return 2;
                }
                if (original.equals("three")) {
                    return 3;
                }
            }
            return null;
        }
    }};
    public static final OutputConverter[] CLI_OUTPUT_CONVERTERS = new OutputConverter[]{new OutputConverter(){

        public Object convertOutput(Object o) {
            if (o.getClass().equals(Integer.class)) {
                int num = (Integer)o;
                if (num == 1) {
                    return "one";
                }
                if (num == 2) {
                    return "two";
                }
                if (num == 3) {
                    return "three";
                }
            }
            return null;
        }
    }};
    private Shell shell;

    @Command(description="Varargs example")
    public Integer add(Integer ... numbers) {
        int result = 0;
        Integer[] arr$ = numbers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            result += i;
        }
        return result;
    }

    @Command(description="setPath example")
    public void setPath(String path) {
        ArrayList<String> pathComps = new ArrayList<String>();
        pathComps.add(path);
        this.shell.setPath(pathComps);
    }

    public void cliSetShell(Shell shell) {
        this.shell = shell;
    }

    @Command(description="Illustrates the concept of subshells, that can be used to create a tree-like navigation")
    public void Hello() throws IOException {
        ShellFactory.createSubshell("hello", this.shell, "That 'Hello, World!' example", new HelloWorld()).commandLoop();
    }

    public static void main(String[] args) throws IOException {
        ShellFactory.createConsoleShell("example", "The Cliche Shell example\nEnter ?l to list available commands.", (Object)new Example()).commandLoop();
    }
}

