/*
 * Decompiled with CFR 0.152.
 */
package asg.cliche;

import asg.cliche.CLIException;
import asg.cliche.Command;
import asg.cliche.CommandNamer;
import asg.cliche.ShellCommand;
import asg.cliche.Token;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandTable {
    private List<ShellCommand> commandTable = new ArrayList<ShellCommand>();
    private CommandNamer namer;

    public CommandNamer getNamer() {
        return this.namer;
    }

    public CommandTable(CommandNamer namer) {
        this.namer = namer;
    }

    public List<ShellCommand> getCommandTable() {
        return Collections.unmodifiableList(this.commandTable);
    }

    public void addMethod(Method method, Object handler, String prefix) {
        String name;
        Command annotation = method.getAnnotation(Command.class);
        assert (method != null);
        String autoAbbrev = null;
        if (annotation != null && annotation.name() != null && !annotation.name().equals("")) {
            name = annotation.name();
        } else {
            CommandNamer.NamingInfo autoNames = this.namer.nameCommand(method);
            name = autoNames.commandName;
            for (String abbr : autoNames.possibleAbbreviations) {
                if (this.doesCommandExist(prefix + abbr, method.getParameterTypes().length)) continue;
                autoAbbrev = abbr;
                break;
            }
        }
        ShellCommand command = new ShellCommand(handler, method, prefix, name);
        if (annotation != null && annotation.abbrev() != null && !annotation.abbrev().equals("")) {
            command.setAbbreviation(annotation.abbrev());
        } else {
            command.setAbbreviation(autoAbbrev);
        }
        if (annotation != null && annotation.description() != null && !annotation.description().equals("")) {
            command.setDescription(annotation.description());
        }
        if (annotation != null && annotation.header() != null && !annotation.header().equals("")) {
            command.setHeader(annotation.header());
        }
        this.commandTable.add(command);
    }

    private boolean doesCommandExist(String commandName, int arity) {
        for (ShellCommand cmd : this.commandTable) {
            if (!cmd.canBeDenotedBy(commandName) || cmd.getArity() != arity) continue;
            return true;
        }
        return false;
    }

    public List<ShellCommand> commandsByName(String discriminator) {
        ArrayList<ShellCommand> collectedTable = new ArrayList<ShellCommand>();
        for (ShellCommand cs : this.commandTable) {
            if (!cs.canBeDenotedBy(discriminator)) continue;
            collectedTable.add(cs);
        }
        return collectedTable;
    }

    public ShellCommand lookupCommand(String discriminator, List<Token> tokens) throws CLIException {
        List<ShellCommand> collectedTable = this.commandsByName(discriminator);
        ArrayList<ShellCommand> reducedTable = new ArrayList<ShellCommand>();
        for (ShellCommand cs : collectedTable) {
            if (cs.getMethod().getParameterTypes().length != tokens.size() - 1 && (!cs.getMethod().isVarArgs() || cs.getMethod().getParameterTypes().length > tokens.size() - 1)) continue;
            reducedTable.add(cs);
        }
        if (collectedTable.size() == 0) {
            throw CLIException.createCommandNotFound(discriminator);
        }
        if (reducedTable.size() == 0) {
            throw CLIException.createCommandNotFoundForArgNum(discriminator, tokens.size() - 1);
        }
        if (reducedTable.size() > 1) {
            throw CLIException.createAmbiguousCommandExc(discriminator, tokens.size() - 1);
        }
        return (ShellCommand)reducedTable.get(0);
    }
}

