/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.ObjectDescriptor;
import org.eclipse.e4.core.internal.di.Requestor;

public class MethodRequestor
extends Requestor<Method> {
    private static Map<Method, Annotation[][]> annotationCache = new WeakHashMap<Method, Annotation[][]>();

    public MethodRequestor(Method method, IInjector injector, PrimaryObjectSupplier primarySupplier, PrimaryObjectSupplier tempSupplier, Object requestingObject, boolean track) {
        super(method, injector, primarySupplier, tempSupplier, requestingObject, track);
    }

    @Override
    public Object execute() throws InjectionException {
        if (this.actualArgs == null && ((Method)this.location).getParameterTypes().length > 0) {
            return null;
        }
        Object userObject = this.getRequestingObject();
        if (userObject == null) {
            return null;
        }
        Object result = null;
        boolean wasAccessible = true;
        if (!((Method)this.location).isAccessible()) {
            ((Method)this.location).setAccessible(true);
            wasAccessible = false;
        }
        boolean pausedRecording = false;
        if (this.primarySupplier != null) {
            this.primarySupplier.pauseRecording();
            pausedRecording = true;
        }
        try {
            try {
                result = ((Method)this.location).invoke(userObject, this.actualArgs);
            }
            catch (IllegalArgumentException e) {
                throw new InjectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new InjectionException(e);
            }
            catch (InvocationTargetException e) {
                Throwable originalException = e.getCause();
                throw new InjectionException(originalException != null ? originalException : e);
            }
        }
        finally {
            if (!wasAccessible) {
                ((Method)this.location).setAccessible(false);
            }
            if (pausedRecording) {
                this.primarySupplier.resumeRecording();
            }
            this.clearResolvedArgs();
        }
        return result;
    }

    @Override
    protected IObjectDescriptor[] calcDependentObjects() {
        Type[] parameterTypes = ((Method)this.location).getGenericParameterTypes();
        Annotation[][] annotations = this.getParameterAnnotations();
        IObjectDescriptor[] descriptors = new IObjectDescriptor[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            descriptors[i] = new ObjectDescriptor(parameterTypes[i], annotations[i]);
            ++i;
        }
        return descriptors;
    }

    public Annotation[][] getParameterAnnotations() {
        Annotation[][] result = annotationCache.get(this.location);
        if (result == null) {
            result = ((Method)this.location).getParameterAnnotations();
            annotationCache.put((Method)this.location, result);
        }
        return result;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        Object object = this.getRequestingObject();
        if (object != null) {
            tmp.append(object.getClass().getSimpleName());
        }
        tmp.append('#');
        tmp.append(((Method)this.location).getName());
        tmp.append('(');
        tmp.append(')');
        return tmp.toString();
    }
}

