/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCellExecutor;

public class CrosstabMeasureHeaderRowExecutor
extends BaseCrosstabExecutor {
    private static Logger logger = Logger.getLogger(CrosstabMeasureHeaderRowExecutor.class.getName());
    private int rowSpan;
    private int colSpan;
    private int currentChangeType;
    private int currentColIndex;
    private int lastMeasureIndex;
    private int lastDimensionIndex;
    private int lastLevelIndex;
    private int totalMeasureCount;
    private long currentEdgePosition;
    private boolean hasColumnGroups;
    private boolean blankStarted;
    private boolean hasLast;
    private boolean isFirst;
    private IReportItemExecutor nextExecutor;

    public CrosstabMeasureHeaderRowExecutor(BaseCrosstabExecutor parent) {
        super(parent);
    }

    public void close() {
        super.close();
        this.nextExecutor = null;
    }

    public IContent execute() {
        IRowContent content = this.context.getReportContent().createRowContent();
        this.initializeContent((IContent)content, null);
        this.processRowHeight(this.findMeasureHeaderCell());
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        this.isFirst = true;
        this.currentChangeType = -1;
        this.currentColIndex = -1;
        this.currentEdgePosition = -1L;
        this.blankStarted = false;
        this.hasColumnGroups = this.columnGroups != null && this.columnGroups.size() > 0;
        this.totalMeasureCount = this.crosstabItem.getMeasureCount();
        this.rowSpan = 1;
        this.colSpan = 0;
        this.lastMeasureIndex = -1;
        this.lastDimensionIndex = -1;
        this.lastLevelIndex = -1;
        this.hasLast = false;
        this.walker.reload();
    }

    private CrosstabCellHandle getSubTotalMeasureHeaderCell(int axis, int dimensionIndex, int levelIndex, int measureIndex) {
        if (measureIndex >= 0 && measureIndex < this.totalMeasureCount && dimensionIndex >= 0 && levelIndex >= 0) {
            DimensionViewHandle dv = this.crosstabItem.getDimension(axis, dimensionIndex);
            LevelViewHandle lv = dv.getLevel(levelIndex);
            return this.crosstabItem.getMeasure(measureIndex).getHeader(lv);
        }
        return null;
    }

    private boolean needCornerHeaderCell() {
        int rgCount;
        if (!this.hasColumnGroups) {
            return true;
        }
        int cgCount = this.columnGroups.size();
        int offset = cgCount * (rgCount = this.rowGroups == null ? 0 : this.rowGroups.size());
        return offset < this.crosstabItem.getHeaderCount();
    }

    private CrosstabCellHandle getCornerHeaderCell(int colIndex) {
        int offset = 0;
        if (this.hasColumnGroups) {
            int rgCount;
            int cgCount = this.columnGroups.size();
            int n = rgCount = this.rowGroups == null ? 0 : this.rowGroups.size();
            if (rgCount == 0) {
                ++rgCount;
            }
            offset = cgCount * rgCount;
        }
        if (colIndex + offset < this.crosstabItem.getHeaderCount()) {
            return this.crosstabItem.getHeader(colIndex + offset);
        }
        return null;
    }

    private void advance() {
        try {
            while (this.walker.hasNext()) {
                ColumnEvent ev = this.walker.next();
                switch (this.currentChangeType) {
                    case 1: 
                    case 5: {
                        int headerCount;
                        if (!this.blankStarted || (headerCount = this.crosstabItem.getHeaderCount()) <= 1 && (ev.type == 1 || ev.type == 5)) break;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.getCornerHeaderCell(this.currentColIndex - this.colSpan + 1), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.blankStarted = false;
                        this.hasLast = false;
                        break;
                    }
                    case 2: 
                    case 6: {
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.lastMeasureIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                        break;
                    }
                    case 3: {
                        this.nextExecutor = new CrosstabCellExecutor(this, this.getSubTotalMeasureHeaderCell(1, this.lastDimensionIndex, this.lastLevelIndex, this.lastMeasureIndex), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                        break;
                    }
                    case 4: {
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.lastMeasureIndex).getHeader(null), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                    }
                }
                if (ev.type == 6 || ev.type == 3 || ev.type == 2 || ev.type == 4) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (!this.blankStarted && (ev.type == 1 || ev.type == 5) && this.needCornerHeaderCell()) {
                    this.blankStarted = true;
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                }
                this.currentEdgePosition = ev.dataPosition;
                this.currentChangeType = ev.type;
                ++this.colSpan;
                ++this.currentColIndex;
                if (this.nextExecutor == null) continue;
                return;
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabMeasureHeaderRowExecutor.error.generate.child.executor"), e);
        }
        if (this.hasLast) {
            this.hasLast = false;
            switch (this.currentChangeType) {
                case 1: 
                case 5: {
                    if (!this.blankStarted) break;
                    this.nextExecutor = new CrosstabCellExecutor(this, this.getCornerHeaderCell(this.currentColIndex - this.colSpan + 1), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    break;
                }
                case 2: 
                case 6: {
                    this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.lastMeasureIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    break;
                }
                case 3: {
                    this.nextExecutor = new CrosstabCellExecutor(this, this.getSubTotalMeasureHeaderCell(1, this.lastDimensionIndex, this.lastLevelIndex, this.lastMeasureIndex), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    break;
                }
                case 4: {
                    this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.lastMeasureIndex).getHeader(null), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                }
            }
        }
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor childExecutor = this.nextExecutor;
        this.nextExecutor = null;
        this.advance();
        return childExecutor;
    }

    public boolean hasNextChild() {
        if (this.isFirst) {
            this.isFirst = false;
            this.advance();
        }
        return this.nextExecutor != null;
    }
}

