/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabReportItemConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabReportItemTask;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstabEventHandler;
import org.eclipse.birt.report.item.crosstab.core.script.internal.CrosstabClassInfo;
import org.eclipse.birt.report.item.crosstab.core.script.internal.CrosstabImpl;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.CompatibilityStatus;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.simpleapi.IReportItem;
import org.eclipse.birt.report.model.api.util.CubeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrosstabReportItemHandle
extends AbstractCrosstabItemHandle
implements ICrosstabReportItemConstants,
ICrosstabConstants {
    int compStatus = 0;

    CrosstabReportItemHandle(DesignElementHandle handle) {
        super(handle);
    }

    public org.eclipse.birt.report.model.api.DimensionHandle getRowHeight(CrosstabCellHandle cell) throws CrosstabException {
        if ((cell = CrosstabModelUtil.locateRowHeightCell(this, cell)) != null) {
            return cell.getHeight();
        }
        throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.locate.row.cell"));
    }

    public org.eclipse.birt.report.model.api.DimensionHandle getColumnWidth(CrosstabCellHandle cell) throws CrosstabException {
        if ((cell = CrosstabModelUtil.locateColumnWidthCell(this, cell)) != null) {
            return cell.getWidth();
        }
        throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.locate.column.cell"));
    }

    public void setRowHeight(CrosstabCellHandle cell, DimensionValue value) throws CrosstabException {
        if ((cell = CrosstabModelUtil.locateRowHeightCell(this, cell)) != null) {
            try {
                cell.getHeight().setValue((Object)value);
            }
            catch (SemanticException e) {
                throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.set.row.height"), e);
            }
        } else {
            throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.locate.row.cell"));
        }
    }

    public void setColumnWidth(CrosstabCellHandle cell, DimensionValue value) throws CrosstabException {
        if ((cell = CrosstabModelUtil.locateColumnWidthCell(this, cell)) != null) {
            try {
                cell.getWidth().setValue((Object)value);
            }
            catch (SemanticException e) {
                throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.set.column.width"), e);
            }
        } else {
            throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.locate.column.cell"));
        }
    }

    PropertyHandle getMeasuresProperty() {
        return this.handle.getPropertyHandle("measures");
    }

    PropertyHandle getRowsProperty() {
        return this.handle.getPropertyHandle("rows");
    }

    PropertyHandle getColumnsProperty() {
        return this.handle.getPropertyHandle("columns");
    }

    protected PropertyHandle getCrosstabViewProperty(int axisType) {
        switch (axisType) {
            case 0: {
                return this.getRowsProperty();
            }
            case 1: {
                return this.getColumnsProperty();
            }
        }
        return null;
    }

    public CrosstabViewHandle getCrosstabView(int axisType) {
        PropertyHandle propHandle = this.getCrosstabViewProperty(axisType);
        if (propHandle == null || propHandle.getContentCount() <= 0) {
            return null;
        }
        return (CrosstabViewHandle)CrosstabUtil.getReportItem(propHandle.getContent(0), "CrosstabView");
    }

    public CrosstabViewHandle addCrosstabView(int axisType) throws SemanticException {
        PropertyHandle propHandle = this.getCrosstabViewProperty(axisType);
        if (propHandle == null || propHandle.getContentCount() > 0) {
            return null;
        }
        ExtendedItemHandle extendedItem = CrosstabExtendedItemFactory.createCrosstabView(this.moduleHandle);
        propHandle.add((DesignElementHandle)extendedItem);
        return (CrosstabViewHandle)CrosstabUtil.getReportItem((DesignElementHandle)extendedItem);
    }

    public String getCaption() {
        return this.handle.getStringProperty("caption");
    }

    public String getCaptionKey() {
        return this.handle.getStringProperty("captionID");
    }

    public String getSummary() {
        return this.handle.getStringProperty("summary");
    }

    public void setCaption(String value) throws SemanticException {
        this.handle.setProperty("caption", (Object)value);
    }

    public void setCaptionKey(String value) throws SemanticException {
        this.handle.setProperty("captionID", (Object)value);
    }

    public void setSummary(String value) throws SemanticException {
        this.handle.setProperty("summary", (Object)value);
    }

    public String getMeasureDirection() {
        return this.handle.getStringProperty("measureDirection");
    }

    public void setMeasureDirection(String direction) throws SemanticException {
        if (direction != null && direction.equals(this.getMeasureDirection())) {
            return;
        }
        CommandStack stack = this.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemHandle.msg.change.measure.direction"));
        try {
            this.handle.setStringProperty("measureDirection", direction);
            new CrosstabReportItemTask(this).validateCrosstab();
            CrosstabModelUtil.updateHeaderCell(this, -2, -1);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void setPageLayout(String value) throws SemanticException {
        this.handle.setProperty("pageLayout", (Object)value);
    }

    public void setRepeatRowHeader(boolean value) throws SemanticException {
        this.handle.setProperty("repeatRowHeader", (Object)value);
    }

    public void setRepeatColumnHeader(boolean value) throws SemanticException {
        this.handle.setProperty("repeatColumnHeader", (Object)value);
    }

    public void setHideMeasureHeader(boolean value) throws SemanticException {
        if (value == this.isHideMeasureHeader()) {
            return;
        }
        this.handle.setProperty("hideMeasureHeader", (Object)value);
        CrosstabModelUtil.updateHeaderCell(this, -1, -1);
    }

    public String getPageLayout() {
        return this.handle.getStringProperty("pageLayout");
    }

    public boolean isRepeatRowHeader() {
        return this.handle.getBooleanProperty("repeatRowHeader");
    }

    public boolean isRepeatColumnHeader() {
        return this.handle.getBooleanProperty("repeatColumnHeader");
    }

    public boolean isHideMeasureHeader() {
        return this.handle.getBooleanProperty("hideMeasureHeader");
    }

    public String getEmptyCellValue() {
        return this.handle.getStringProperty("emptyCellValue");
    }

    public void setEmptyCellValue(String value) throws SemanticException {
        this.handle.setStringProperty("emptyCellValue", value);
    }

    public int getRowPageBreakInterval() {
        return this.handle.getIntProperty("rowPageBreakInterval");
    }

    public void setRowPageBreakInterval(int value) throws SemanticException {
        this.handle.setIntProperty("rowPageBreakInterval", value);
    }

    public int getColumnPageBreakInterval() {
        return this.handle.getIntProperty("columnPageBreakInterval");
    }

    public void setColumnPageBreakInterval(int value) throws SemanticException {
        this.handle.setIntProperty("columnPageBreakInterval", value);
    }

    public Iterator filtersIterator() {
        PropertyHandle propHandle = this.handle.getPropertyHandle("filter");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.getListValue().iterator();
    }

    public CrosstabCellHandle getHeader() {
        PropertyHandle headerHandle = this.handle.getPropertyHandle("header");
        if (headerHandle != null && headerHandle.getContentCount() > 0) {
            return (CrosstabCellHandle)CrosstabUtil.getReportItem(headerHandle.getContent(0));
        }
        return null;
    }

    public CubeHandle getCube() {
        return this.handle.getCube();
    }

    public void setCube(CubeHandle cube) throws SemanticException {
        this.handle.setProperty("cube", (Object)cube);
    }

    public String getCubeName() {
        String cubeName = this.handle.getStringProperty("cube");
        if (cubeName == null && this.getCube() != null) {
            cubeName = this.getCube().getName();
        }
        return cubeName;
    }

    public DimensionViewHandle getDimension(String name) {
        DimensionViewHandle dimensionView = this.findDimension(0, name);
        if (dimensionView != null) {
            return dimensionView;
        }
        dimensionView = this.findDimension(1, name);
        if (dimensionView != null) {
            return dimensionView;
        }
        return null;
    }

    private DimensionViewHandle findDimension(int axisType, String name) {
        CrosstabViewHandle crosstabView = this.getCrosstabView(axisType);
        return crosstabView == null ? null : crosstabView.getDimension(name);
    }

    public DimensionViewHandle getDimension(int axisType, int index) {
        CrosstabViewHandle crosstabView = this.getCrosstabView(axisType);
        return crosstabView == null ? null : crosstabView.getDimension(index);
    }

    public int getDimensionCount(int axisType) {
        CrosstabViewHandle crosstabView = this.getCrosstabView(axisType);
        return crosstabView == null ? 0 : crosstabView.getDimensionCount();
    }

    public LevelViewHandle getLevel(String fullLevelName) {
        String[] slices = CubeUtil.splitLevelName((String)fullLevelName);
        DimensionViewHandle dv = this.getDimension(slices[0]);
        if (dv != null) {
            return dv.getLevel(fullLevelName);
        }
        return null;
    }

    public MeasureViewHandle getMeasure(String name) {
        int i = 0;
        while (i < this.getMeasureCount()) {
            String cubeMeasureName;
            MeasureViewHandle measureView = this.getMeasure(i);
            if (measureView != null && ((cubeMeasureName = measureView.getCubeMeasureName()) != null && cubeMeasureName.equals(name) || cubeMeasureName == null && name == null)) {
                return measureView;
            }
            ++i;
        }
        return null;
    }

    public MeasureViewHandle getMeasure(int index) {
        DesignElementHandle element = this.getMeasuresProperty().getContent(index);
        return (MeasureViewHandle)CrosstabUtil.getReportItem(element);
    }

    public int getMeasureCount() {
        return this.getMeasuresProperty().getContentCount();
    }

    public List<MeasureViewHandle> getAllMeasures() {
        ArrayList<MeasureViewHandle> measureList = new ArrayList<MeasureViewHandle>();
        int i = 0;
        while (i < this.getMeasureCount()) {
            measureList.add(this.getMeasure(i));
            ++i;
        }
        return measureList;
    }

    public DimensionViewHandle insertDimension(DimensionHandle dimensionHandle, int axisType, int index) throws SemanticException {
        return new CrosstabReportItemTask(this).insertDimension(dimensionHandle, axisType, index);
    }

    public MeasureViewHandle insertMeasure(MeasureHandle measureHandle, int index) throws SemanticException {
        if (measureHandle != null && this.getMeasure(measureHandle.getQualifiedName()) != null) {
            logger.log(Level.SEVERE, "Error.CrosstabException.DUPLICATE_MEASURE", measureHandle.getQualifiedName());
            throw new CrosstabException(this.handle.getElement(), Messages.getString("Error.CrosstabException.DUPLICATE_MEASURE", measureHandle.getQualifiedName()));
        }
        CommandStack stack = this.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemHandle.msg.insert.measure"));
        MeasureViewHandle mv = null;
        try {
            ExtendedItemHandle extendedItemHandle = CrosstabExtendedItemFactory.createMeasureView(this.moduleHandle, measureHandle);
            if (extendedItemHandle != null) {
                this.getMeasuresProperty().add((DesignElementHandle)extendedItemHandle, index);
                new CrosstabReportItemTask(this).validateCrosstab();
                mv = (MeasureViewHandle)CrosstabUtil.getReportItem((DesignElementHandle)extendedItemHandle);
                CrosstabModelUtil.updateHeaderCell(this, -1, -1);
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return mv;
    }

    public ComputedMeasureViewHandle insertComputedMeasure(String name, int index) throws SemanticException {
        return this.insertComputedMeasure(name, index, false);
    }

    public ComputedMeasureViewHandle insertComputedMeasure(String name, int index, boolean isMeasureView) throws SemanticException {
        if (name == null) {
            throw new CrosstabException(Messages.getString("CrosstabReportItemHandle.exception.name.blank"));
        }
        if (this.getMeasure(name) != null) {
            throw new CrosstabException(Messages.getString("CrosstabReportItemHandle.exception.name.duplicate"));
        }
        CommandStack stack = this.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemHandle.msg.insert.measure"));
        ComputedMeasureViewHandle mv = null;
        try {
            ExtendedItemHandle extendedItemHandle = CrosstabExtendedItemFactory.createComputedMeasureView(this.moduleHandle, name);
            if (extendedItemHandle != null) {
                if (isMeasureView) {
                    extendedItemHandle.setProperty("measureName", (Object)name);
                }
                this.getMeasuresProperty().add((DesignElementHandle)extendedItemHandle, index);
                new CrosstabReportItemTask(this).validateCrosstab();
                mv = (ComputedMeasureViewHandle)CrosstabUtil.getReportItem((DesignElementHandle)extendedItemHandle);
                CrosstabModelUtil.updateHeaderCell(this, -1, -1);
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return mv;
    }

    public List<ComputedMeasureViewHandle> getComputedMeasures() {
        ArrayList<ComputedMeasureViewHandle> ms = new ArrayList<ComputedMeasureViewHandle>();
        int i = 0;
        while (i < this.getMeasureCount()) {
            MeasureViewHandle measureView = this.getMeasure(i);
            if (measureView instanceof ComputedMeasureViewHandle) {
                ms.add((ComputedMeasureViewHandle)measureView);
            }
            ++i;
        }
        if (ms.size() == 0) {
            return Collections.emptyList();
        }
        return ms;
    }

    public void removeDimension(String name) throws SemanticException {
        new CrosstabReportItemTask(this).removeDimension(name);
    }

    public void removeDimension(int axisType, int index) throws SemanticException {
        new CrosstabReportItemTask(this).removeDimension(axisType, index);
    }

    public void removeMeasure(String name) throws SemanticException {
        MeasureViewHandle measureView = this.getMeasure(name);
        if (measureView == null) {
            logger.log(Level.SEVERE, "Error.CrosstabException.MEASURE_NOT_FOUND", name);
            throw new CrosstabException(this.handle.getElement(), Messages.getString("Error.CrosstabException.MEASURE_NOT_FOUND", name));
        }
        this.removeMeasure(measureView.getIndex());
    }

    public void removeMeasure(int index) throws SemanticException {
        this.getMeasuresProperty().drop(index);
        int targetAxis = "vertical".equals(this.getMeasureDirection()) ? 0 : 1;
        List<LevelViewHandle> levels = CrosstabModelUtil.getAllAggregationLevels(this, targetAxis);
        for (LevelViewHandle lv : levels) {
            if (lv.isInnerMost() || lv.getAggregationHeader() == null || lv.getAggregationMeasures().size() != 0) continue;
            lv.getAggregationHeaderProperty().drop(0);
        }
        CrosstabCellHandle grandtotalCell = this.getGrandTotal(targetAxis);
        if (grandtotalCell != null && this.getAggregationMeasures(targetAxis).size() == 0) {
            grandtotalCell.getModelHandle().drop();
        }
        CrosstabModelUtil.updateHeaderCell(this, -1, -1);
    }

    public void pivotDimension(String name, int targetAxisType, int targetIndex) throws SemanticException {
        new CrosstabReportItemTask(this).pivotDimension(name, targetAxisType, targetIndex);
    }

    public void pivotDimension(int srcAxisType, int srcIndex, int targetAxisType, int targetIndex) throws SemanticException {
        new CrosstabReportItemTask(this).pivotDimension(srcAxisType, srcIndex, targetAxisType, targetIndex);
    }

    public void pivotCrosstab() throws SemanticException {
        new CrosstabReportItemTask(this).pivotCrosstab();
    }

    public CrosstabCellHandle getGrandTotal(int axisType) {
        CrosstabViewHandle crosstabView = this.getCrosstabView(axisType);
        return crosstabView == null ? null : crosstabView.getGrandTotal();
    }

    public CrosstabCellHandle addGrandTotal(int axisType) throws SemanticException {
        ArrayList<MeasureViewHandle> measures = new ArrayList<MeasureViewHandle>();
        ArrayList<String> functions = new ArrayList<String>();
        int i = 0;
        while (i < this.getMeasureCount()) {
            MeasureViewHandle mv = this.getMeasure(i);
            measures.add(mv);
            functions.add(CrosstabModelUtil.getDefaultMeasureAggregationFunction(mv));
            ++i;
        }
        return this.addGrandTotal(axisType, measures, functions);
    }

    public void removeGrandTotal(int axisType) throws SemanticException {
        new CrosstabReportItemTask(this).removeGrandTotal(axisType);
    }

    public void removeGrandTotal(int axisType, int measureIndex) throws SemanticException {
        new CrosstabReportItemTask(this).removeGrandTotal(axisType, measureIndex);
    }

    public org.eclipse.birt.report.model.api.DimensionHandle getWidth() {
        return this.handle.getDimensionProperty("width");
    }

    public org.eclipse.birt.report.model.api.DimensionHandle getHeight() {
        return this.handle.getDimensionProperty("height");
    }

    public void pivotMeasure(String name, int toIndex) throws SemanticException {
        MeasureViewHandle measureView = this.getMeasure(name);
        if (measureView == null) {
            logger.log(Level.SEVERE, "Error.CrosstabException.MEASURE_NOT_FOUND", name);
            throw new CrosstabException(this.handle.getElement(), Messages.getString("Error.CrosstabException.MEASURE_NOT_FOUND", name));
        }
        measureView.handle.moveTo(toIndex);
    }

    public void pivotMeasure(int fromIndex, int toIndex) throws SemanticException {
        MeasureViewHandle measureView = this.getMeasure(fromIndex);
        if (measureView == null) {
            logger.log(Level.INFO, "Error.CrosstabException.MEASURE_NOT_FOUND", String.valueOf(fromIndex));
            return;
        }
        measureView.handle.moveTo(toIndex);
    }

    public CrosstabCellHandle addGrandTotal(int axisType, List measureList, List functionList) throws SemanticException {
        return new CrosstabReportItemTask(this).addGrandTotal(axisType, measureList, functionList);
    }

    public List getAggregationMeasures(int axisType) {
        return new CrosstabReportItemTask(this).getAggregationMeasures(axisType);
    }

    public String getAggregationFunction(int axisType, MeasureViewHandle measureView) {
        return new CrosstabReportItemTask(this).getAggregationFunction(axisType, measureView);
    }

    public void setAggregationFunction(int axisType, MeasureViewHandle measureView, String function) throws SemanticException {
        new CrosstabReportItemTask(this).setAggregationFunction(axisType, measureView, function);
    }

    public IReportItem getSimpleElement() {
        return new CrosstabImpl(this);
    }

    private IMethodInfo[] getFilteredMethods(String contextName) {
        CrosstabClassInfo info = new CrosstabClassInfo(ICrosstabEventHandler.class);
        List list = info.getMethods();
        ArrayList<IMethodInfo> filtered = new ArrayList<IMethodInfo>();
        for (IMethodInfo md : list) {
            String name = md.getName();
            if (name == null || !name.startsWith(contextName)) continue;
            filtered.add(md);
        }
        return filtered.toArray(new IMethodInfo[filtered.size()]);
    }

    public IMethodInfo[] getMethods(String methodName) {
        if ("onPrepare".equals(methodName) || "onCreate".equals(methodName) || "onRender".equals(methodName)) {
            return this.getFilteredMethods(methodName);
        }
        return null;
    }

    public CompatibilityStatus checkCompatibility() {
        this.compStatus = CrosstabReportItemHandle.checkVersion(this.handle.getExtensionVersion());
        if (this.compStatus < 0) {
            PropertyHandle headerHandle;
            CompatibilityStatus status = new CompatibilityStatus();
            ArrayList<SemanticException> errorList = new ArrayList<SemanticException>(2);
            status.setStatusType(2);
            try {
                this.handle.setExtensionVersion("3.7.0");
            }
            catch (SemanticException e) {
                errorList.add(e);
            }
            if (this.getHeader() == null && (headerHandle = this.handle.getPropertyHandle("header")) != null) {
                try {
                    headerHandle.setValue((Object)CrosstabExtendedItemFactory.createCrosstabCell(this.getModuleHandle()));
                    CrosstabModelUtil.validateCrosstabHeader(this);
                }
                catch (SemanticException e) {
                    errorList.add(e);
                }
            }
            if (errorList.size() > 0) {
                status.setErrors(errorList);
            }
            return status;
        }
        if (this.compStatus > 0) {
            return new CompatibilityStatus(Collections.EMPTY_LIST, 1);
        }
        return COMP_OK_STATUS;
    }

    public List validate() {
        ArrayList<ExtendedElementException> list = new ArrayList<ExtendedElementException>();
        if (!this.getModelHandle().isInTemplateParameter() && this.getCube() == null && !(this.getModelHandle().getRoot() instanceof LibraryHandle)) {
            ExtendedElementException extendedException = new ExtendedElementException(this.getModelHandle().getElement(), "org.eclipse.birt.report.item.crosstab.core", "CrosstabReportItemHandle.Error.HasNoCube", new Object[]{"Erorr"}, Messages.getResourceBundle());
            list.add(extendedException);
        }
        return list;
    }

    public CrosstabCellHandle getHeader(int index) {
        PropertyHandle headerHandle = this.handle.getPropertyHandle("header");
        if (headerHandle == null) {
            return null;
        }
        List list = headerHandle.getContents();
        if (list == null || index < 0 || index > list.size() - 1) {
            return null;
        }
        return (CrosstabCellHandle)CrosstabUtil.getReportItem(headerHandle.getContent(index));
    }

    public int getHeaderCount() {
        PropertyHandle headerHandle = this.handle.getPropertyHandle("header");
        if (headerHandle == null) {
            return 0;
        }
        return headerHandle.getContentCount();
    }
}

