/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.application;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.OpenSessionAction;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public final class OpenFilesFromCommandLineJob
extends Job {
    private final IWorkbenchWindow window;
    private static String ARG_HOST = "--host=";
    private static String ARG_USER = "--user=";
    private static String ARG_PORT = "--port=";
    private static String ARG_CONNECTION_TYPE = "--connection-type=";
    private static String ARG_TOOLKIT = "--toolkit=";

    private static String fileNames(Collection<String> fileNames) {
        StringBuilder builder = new StringBuilder();
        for (String fileName : fileNames) {
            builder.append(fileName);
        }
        return builder.toString();
    }

    protected static String getMissingFileMessage(List<String> missingFiles) {
        if (missingFiles.size() == 1) {
            return MessageFormat.format(ViperMessages.Open_Fail_Single_File, missingFiles.get(0));
        }
        return MessageFormat.format(ViperMessages.Open_Fail_Multiple_Files, OpenFilesFromCommandLineJob.fileNames(missingFiles));
    }

    public OpenFilesFromCommandLineJob(IWorkbenchWindow window) {
        super(ViperMessages.Open_Job_Title);
        this.window = window;
        this.setSystem(true);
        this.setUser(false);
    }

    protected IStatus run(IProgressMonitor monitor) {
        String[] args = Platform.getApplicationArgs();
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)(args.length * 10));
        return this.doOpenFiles((IProgressMonitor)m, args);
    }

    private void showMissingDialog(final List<String> missingFiles) {
        boolean dialogDisabled = Boolean.parseBoolean(System.getProperty("viper.test.noMissingFileDialog"));
        if (dialogDisabled) {
            System.err.println(OpenFilesFromCommandLineJob.getMissingFileMessage(missingFiles));
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ViperMessageDialog.openError((Shell)OpenFilesFromCommandLineJob.this.window.getShell(), (String)ViperMessages.Open_Fail_Title, (String)OpenFilesFromCommandLineJob.getMissingFileMessage(missingFiles));
            }
        });
    }

    private IStatus doOpenFiles(IProgressMonitor m, String[] args) {
        final OpenSessionAction.RemoteConnectionArgs remote = new OpenSessionAction.RemoteConnectionArgs();
        LinkedList<String> listFiles = new LinkedList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String str;
            String arg = stringArray[n2];
            if (arg.startsWith(ARG_HOST)) {
                remote.host = arg.replaceAll(ARG_HOST, "");
            } else if (arg.startsWith(ARG_USER)) {
                remote.user = arg.replaceFirst(ARG_USER, "");
            } else if (arg.startsWith(ARG_CONNECTION_TYPE)) {
                remote.type = arg.replaceFirst(ARG_CONNECTION_TYPE, "");
            } else if (arg.startsWith(ARG_PORT)) {
                str = arg.replaceFirst(ARG_PORT, "");
                remote.port = Integer.valueOf(str);
            } else if (arg.startsWith(ARG_TOOLKIT)) {
                remote.toolkit = str = arg.replaceFirst(ARG_TOOLKIT, "");
            } else if (!arg.startsWith("-")) {
                listFiles.add(arg);
            }
            ++n2;
        }
        String[] files = listFiles.toArray(new String[listFiles.size()]);
        LinkedList<String> missingFiles = new LinkedList<String>();
        int i = 0;
        while (i < files.length) {
            if (m.isCanceled()) {
                return new Status(8, "com.nvidia.viper.application", ViperMessages.Open_Job_Canceled);
            }
            String fName = files[i];
            if (!(remote.host != null && remote.user != null || CoreUtil.fileExists((String)fName) || CoreUtil.getFileOnPath((String)fName) != null)) {
                if (!fName.startsWith("-")) {
                    missingFiles.add(fName);
                }
            } else {
                final String[] remainderArgs = Arrays.copyOfRange(files, i, files.length);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OpenSessionAction.handleOpenFiles((IWorkbenchWindow)OpenFilesFromCommandLineJob.this.window, (String[])remainderArgs, (OpenSessionAction.RemoteConnectionArgs)remote);
                    }
                });
                m.worked(10);
                break;
            }
            m.worked(10);
            ++i;
        }
        if (!missingFiles.isEmpty()) {
            this.showMissingDialog(missingFiles);
        }
        m.done();
        return Status.OK_STATUS;
    }
}

