/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemDNDTransferRunnable;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.internal.model.SystemRegistryUI;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;
import org.eclipse.ui.part.ResourceTransfer;

public class SystemPasteFromClipboardAction
extends SystemBaseAction
implements IValidatorRemoteSelection {
    private int _srcType = 0;
    private Object _selection;

    public SystemPasteFromClipboardAction(Shell shell, Clipboard clipboard) {
        this(shell);
    }

    private SystemPasteFromClipboardAction(Shell shell) {
        super(SystemResources.ACTION_PASTE_LABEL, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"), shell);
        this.setEnabled(false);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.reorganize");
        this.setHelp("org.eclipse.rse.ui.actn0117");
    }

    public void run() {
        if (this._selection != null) {
            this.pasteClipboardToSelection(this._selection);
        }
    }

    private void pasteClipboardToSelection(Object target) {
        List srcObjects = RSEUIPlugin.getTheSystemRegistryUI().getSystemClipboardObjects(this._srcType);
        if (srcObjects.size() > 0) {
            SystemDNDTransferRunnable runnable = new SystemDNDTransferRunnable(target, (ArrayList)srcObjects, this.getViewer(), this._srcType);
            runnable.schedule();
            RSEUIPlugin.getTheSystemRegistryUI().clearRunnableContext();
        }
    }

    public SystemMessage isValid(IHost selectedConnection, Object[] selectedObjects, ISystemRemoteElementAdapter[] remoteAdaptersForSelectedObjects) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean hasSource() {
        Clipboard clipboard;
        block14: {
            Object object;
            block16: {
                block15: {
                    block13: {
                        PluginTransferData data;
                        byte[] result;
                        clipboard = SystemRegistryUI.getInstance().getSystemClipboard();
                        Clipboard clipboard2 = clipboard;
                        // MONITORENTER : clipboard2
                        object = clipboard.getContents((Transfer)PluginTransfer.getInstance());
                        if (object == null) break block13;
                        if (!(object instanceof PluginTransferData) || (result = (data = (PluginTransferData)object).getData()) == null) break block14;
                        this._srcType = 0;
                        // MONITOREXIT : clipboard2
                        {
                            catch (Throwable throwable) {
                                // MONITOREXIT : clipboard2
                                throw throwable;
                            }
                        }
                        clipboard.dispose();
                        return true;
                    }
                    ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                    object = clipboard.getContents((Transfer)resTransfer);
                    if (object == null) break block15;
                    IResource[] resourceData = (IResource[])object;
                    if (resourceData.length <= 0) break block14;
                    this._srcType = 1;
                    // MONITOREXIT : clipboard2
                    clipboard.dispose();
                    return true;
                }
                FileTransfer fileTransfer = FileTransfer.getInstance();
                object = clipboard.getContents((Transfer)fileTransfer);
                if (object == null) break block16;
                String[] fileData = (String[])object;
                if (fileData.length <= 0) break block14;
                this._srcType = 2;
                // MONITOREXIT : clipboard2
                clipboard.dispose();
                return true;
            }
            TextTransfer textTransfer = TextTransfer.getInstance();
            object = clipboard.getContents((Transfer)textTransfer);
            if (object == null) break block14;
            this._srcType = 3;
            // MONITOREXIT : clipboard2
            clipboard.dispose();
            return true;
        }
        try {
            // MONITOREXIT : clipboard2
            return false;
        }
        catch (Exception exception) {
            clipboard.dispose();
            return false;
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (this.hasSource()) {
            boolean enable = true;
            Iterator e = selection.iterator();
            while (enable && e.hasNext()) {
                Object selectedObject = e.next();
                if (selectedObject instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)selectedObject;
                    ISystemDragDropAdapter va = (ISystemDragDropAdapter)adaptable.getAdapter(ISystemDragDropAdapter.class);
                    if (va != null) {
                        enable = va.canDrop(selectedObject);
                        if (!enable) continue;
                        enable = this._srcType != 3 && this._srcType != 4;
                        continue;
                    }
                    enable = false;
                    continue;
                }
                enable = false;
            }
            if (enable) {
                this._selection = selection.getFirstElement();
            }
            return enable;
        }
        return false;
    }

    protected IRunnableContext getRunnableContext(Shell shell) {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistryUI().getRunnableContext();
        if (irc != null) {
            return irc;
        }
        irc = new ProgressMonitorDialog(shell);
        RSEUIPlugin.getTheSystemRegistryUI().setRunnableContext(shell, irc);
        return irc;
    }
}

