/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalCompound;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;

public class CPPASTCompoundStatementExpression
extends ASTNode
implements IGNUASTCompoundStatementExpression,
ICPPASTExpression {
    private IASTCompoundStatement statement;
    private ICPPEvaluation fEval;

    public CPPASTCompoundStatementExpression() {
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEval == null) {
            IASTStatement st;
            IASTCompoundStatement compound = this.getCompoundStatement();
            IASTStatement[] statements = compound.getStatements();
            if (statements.length > 0 && (st = statements[statements.length - 1]) instanceof IASTExpressionStatement) {
                this.fEval = new EvalCompound(((ICPPASTExpression)((IASTExpressionStatement)st).getExpression()).getEvaluation(), this);
            }
            if (this.fEval == null) {
                this.fEval = EvalFixed.INCOMPLETE;
            }
        }
        return this.fEval;
    }

    public CPPASTCompoundStatementExpression(IASTCompoundStatement statement) {
        this.setCompoundStatement(statement);
    }

    @Override
    public CPPASTCompoundStatementExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTCompoundStatementExpression copy(IASTNode.CopyStyle style) {
        CPPASTCompoundStatementExpression copy = new CPPASTCompoundStatementExpression();
        copy.setCompoundStatement(this.statement == null ? null : this.statement.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTCompoundStatement getCompoundStatement() {
        return this.statement;
    }

    @Override
    public void setCompoundStatement(IASTCompoundStatement statement) {
        this.assertNotFrozen();
        this.statement = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(STATEMENT);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.statement != null && !this.statement.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getTypeOrFunctionSet(this);
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }
}

