/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadOutputStream;
import org.eclipse.help.webapp.IFilter;

public class FramesetFilter
implements IFilter {
    private static final String scriptPart1 = "<script type=\"text/javascript\">\nif( self == top ){\n  var  anchorParam = location.hash.length > 0 ? '" + UrlUtil.JavaScriptEncode("&") + "anchor=' + location.hash.substr(1) : '';" + "\n  window.location.replace( \"";
    private static final String scriptPart3 = "\" + anchorParam);\n}\n</script>";

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        int i;
        String uri = req.getRequestURI();
        String url = req.getPathInfo();
        String query = req.getQueryString();
        if (uri == null) {
            return out;
        }
        boolean isNavPath = UrlUtil.isNavPath(uri);
        if (!(uri.endsWith("html") || uri.endsWith("htm") || isNavPath)) {
            return out;
        }
        if ("/nftopic".equals(req.getServletPath()) || "/ntopic".equals(req.getServletPath()) || "/rtopic".equals(req.getServletPath()) || UrlUtil.isBot(req)) {
            return out;
        }
        String noframes = req.getParameter("noframes");
        if ("true".equals(noframes)) {
            return out;
        }
        String path = req.getPathInfo();
        if (path == null) {
            return out;
        }
        StringBuffer script = new StringBuffer(scriptPart1);
        while ((i = path.indexOf(47)) >= 0) {
            script.append("../");
            path = path.substring(i + 1);
        }
        if (isNavPath) {
            script.append("index.jsp?nav=");
        } else {
            script.append("index.jsp?topic=");
        }
        try {
            url = URLEncoder.encode(url, "UTF-8");
            if (query != null) {
                url = String.valueOf(url) + UrlUtil.JavaScriptEncode("&") + query;
            }
            script.append(url);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return out;
        }
        script.append(scriptPart3);
        try {
            return new FilterHTMLHeadOutputStream(out, script.toString().getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return out;
        }
    }
}

